/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.management.counter.Counter;
import sun.management.counter.Units;
import sun.management.counter.perf.PerfInstrumentation;
import sun.misc.Perf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorAddressLink {
    private static final String CONNECTOR_ADDRESS_COUNTER = "sun.management.JMXConnectorServer.address";

    public static void export(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("address not specified");
        }
        Perf perf = Perf.getPerf();
        perf.createString(CONNECTOR_ADDRESS_COUNTER, 1, Units.STRING.intValue(), string);
    }

    public static String importFrom(int n2) throws IOException {
        ByteBuffer byteBuffer;
        Perf perf = Perf.getPerf();
        try {
            byteBuffer = perf.attach(n2, "r");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.getMessage());
        }
        List list = new PerfInstrumentation(byteBuffer).findByPattern(CONNECTOR_ADDRESS_COUNTER);
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            Counter counter = (Counter)iterator.next();
            return (String)counter.getValue();
        }
        return null;
    }

    public static List<ManagedVirtualMachine> managedVirtualMachines() {
        Set<Integer> set;
        Object object;
        try {
            object = MonitoredHost.getMonitoredHost(new HostIdentifier((String)null));
            set = ((MonitoredHost)object).activeVms();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InternalError(uRISyntaxException.getMessage());
        }
        catch (MonitorException monitorException) {
            throw new InternalError(monitorException.getMessage());
        }
        object = new ArrayList();
        for (Integer n2 : set) {
            try {
                int n3 = n2;
                String string = ConnectorAddressLink.importFrom(n3);
                if (string == null) continue;
                ((ArrayList)object).add(new ManagedVirtualMachine(n3, string));
            }
            catch (IOException iOException) {}
        }
        return object;
    }

    public static class ManagedVirtualMachine {
        private int vmid;
        private String address;

        ManagedVirtualMachine(int n2, String string) {
            this.vmid = n2;
            this.address = string;
        }

        public int vmid() {
            return this.vmid;
        }

        public String connectorAddress() {
            return this.address;
        }
    }
}

