/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.util;

import java.util.logging.Level;
import java.util.logging.Logger;

public class MibLogger {
    final Logger logger;
    final String className;

    static String getClassName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isArray()) {
            return MibLogger.getClassName(clazz.getComponentType()) + "[]";
        }
        String string = clazz.getName();
        int n2 = string.lastIndexOf(46);
        int n3 = string.length();
        if (n2 < 0 || n2 >= n3) {
            return string;
        }
        return string.substring(n2 + 1, n3);
    }

    static String getLoggerName(Class clazz) {
        if (clazz == null) {
            return "sun.management.snmp.jvminstr";
        }
        Package package_ = clazz.getPackage();
        if (package_ == null) {
            return "sun.management.snmp.jvminstr";
        }
        String string = package_.getName();
        if (string == null) {
            return "sun.management.snmp.jvminstr";
        }
        return string;
    }

    public MibLogger(Class clazz) {
        this(MibLogger.getLoggerName(clazz), MibLogger.getClassName(clazz));
    }

    public MibLogger(Class clazz, String string) {
        this(MibLogger.getLoggerName(clazz) + (string == null ? "" : "." + string), MibLogger.getClassName(clazz));
    }

    public MibLogger(String string) {
        this("sun.management.snmp.jvminstr", string);
    }

    public MibLogger(String string, String string2) {
        Logger logger = null;
        try {
            logger = Logger.getLogger(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logger = logger;
        this.className = string2;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public boolean isTraceOn() {
        Logger logger = this.getLogger();
        if (logger == null) {
            return false;
        }
        return logger.isLoggable(Level.FINE);
    }

    public boolean isDebugOn() {
        Logger logger = this.getLogger();
        if (logger == null) {
            return false;
        }
        return logger.isLoggable(Level.FINEST);
    }

    public boolean isInfoOn() {
        Logger logger = this.getLogger();
        if (logger == null) {
            return false;
        }
        return logger.isLoggable(Level.INFO);
    }

    public void error(String string, String string2) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.logp(Level.SEVERE, this.className, string, string2);
        }
    }

    public void info(String string, String string2) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.logp(Level.INFO, this.className, string, string2);
        }
    }

    public void info(String string, Throwable throwable) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.logp(Level.INFO, this.className, string, throwable.toString(), throwable);
        }
    }

    public void info(String string, String string2, Throwable throwable) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.logp(Level.INFO, this.className, string, string2, throwable);
        }
    }

    public void warning(String string, String string2) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.logp(Level.WARNING, this.className, string, string2);
        }
    }

    public void warning(String string, Throwable throwable) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.logp(Level.WARNING, this.className, string, throwable.toString(), throwable);
        }
    }

    public void warning(String string, String string2, Throwable throwable) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.logp(Level.WARNING, this.className, string, string2, throwable);
        }
    }

    public void trace(String string, String string2) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.logp(Level.FINE, this.className, string, string2);
        }
    }

    public void trace(String string, Throwable throwable) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.logp(Level.FINE, this.className, string, throwable.toString(), throwable);
        }
    }

    public void trace(String string, String string2, Throwable throwable) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.logp(Level.FINE, this.className, string, string2, throwable);
        }
    }

    public void debug(String string, String string2) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.logp(Level.FINEST, this.className, string, string2);
        }
    }

    public void debug(String string, Throwable throwable) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.logp(Level.FINEST, this.className, string, throwable.toString(), throwable);
        }
    }

    public void debug(String string, String string2, Throwable throwable) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.logp(Level.FINEST, this.className, string, string2, throwable);
        }
    }
}

