/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.misc.PathPermissions;
import sun.misc.URLClassPath;
import sun.net.www.ParseUtil;
import sun.security.action.GetPropertyAction;

public class Launcher {
    private static URLStreamHandlerFactory factory = new Factory();
    private static Launcher launcher = new Launcher();
    private ClassLoader loader;
    private static URLStreamHandler fileHandler;

    public static Launcher getLauncher() {
        return launcher;
    }

    public Launcher() {
        ExtClassLoader extClassLoader;
        try {
            extClassLoader = ExtClassLoader.getExtClassLoader();
        }
        catch (IOException iOException) {
            throw new InternalError("Could not create extension class loader");
        }
        try {
            this.loader = AppClassLoader.getAppClassLoader(extClassLoader);
        }
        catch (IOException iOException) {
            throw new InternalError("Could not create application class loader");
        }
        Thread.currentThread().setContextClassLoader(this.loader);
        String string = System.getProperty("java.security.manager");
        if (string != null) {
            SecurityManager securityManager = null;
            if ("".equals(string) || "default".equals(string)) {
                securityManager = new SecurityManager();
            } else {
                try {
                    securityManager = (SecurityManager)this.loader.loadClass(string).newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (securityManager != null) {
                System.setSecurityManager(securityManager);
            } else {
                throw new InternalError("Could not create SecurityManager: " + string);
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public static boolean appendToClassPathForInstrumentation(ClassLoader classLoader, File file) {
        URL uRL = Launcher.getFileURL(file);
        if (classLoader instanceof AppClassLoader) {
            ((AppClassLoader)classLoader).addInstrumentationURL(uRL);
            return true;
        }
        return false;
    }

    public static URLClassPath getBootstrapClassPath() {
        URL[] uRLArray;
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.boot.class.path"));
        if (string != null) {
            final String string2 = string;
            uRLArray = (URL[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Launcher.pathToURLs(Launcher.getClassPath(string2));
                }
            });
        } else {
            uRLArray = new URL[]{};
        }
        return new URLClassPath(uRLArray, factory);
    }

    private static URL[] pathToURLs(File[] fileArray) {
        URL[] uRLArray = new URL[fileArray.length];
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            uRLArray[i2] = Launcher.getFileURL(fileArray[i2]);
        }
        return uRLArray;
    }

    private static File[] getClassPath(String string) {
        File[] fileArray;
        if (string != null) {
            int n2 = 0;
            int n3 = 1;
            int n4 = 0;
            int n5 = 0;
            while ((n4 = string.indexOf(File.pathSeparator, n5)) != -1) {
                ++n3;
                n5 = n4 + 1;
            }
            fileArray = new File[n3];
            n4 = 0;
            n5 = 0;
            while ((n4 = string.indexOf(File.pathSeparator, n5)) != -1) {
                fileArray[n2++] = n4 - n5 > 0 ? new File(string.substring(n5, n4)) : new File(".");
                n5 = n4 + 1;
            }
            fileArray[n2++] = n5 < string.length() ? new File(string.substring(n5)) : new File(".");
            if (n2 != n3) {
                File[] fileArray2 = new File[n2];
                System.arraycopy(fileArray, 0, fileArray2, 0, n2);
                fileArray = fileArray2;
            }
        } else {
            fileArray = new File[]{};
        }
        return fileArray;
    }

    static URL getFileURL(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            return ParseUtil.fileToEncodedURL(file);
        }
        catch (MalformedURLException malformedURLException) {
            throw new InternalError();
        }
    }

    static class AppClassLoader
    extends URLClassLoader {
        public static ClassLoader getAppClassLoader(final ClassLoader classLoader) throws IOException {
            final String string = System.getProperty("java.class.path");
            final File[] fileArray = string == null ? new File[]{} : Launcher.getClassPath(string);
            return (AppClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL[] uRLArray = string == null ? new URL[]{} : Launcher.pathToURLs(fileArray);
                    return new AppClassLoader(uRLArray, classLoader);
                }
            });
        }

        AppClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader, factory);
        }

        public synchronized Class loadClass(String string, boolean bl2) throws ClassNotFoundException {
            SecurityManager securityManager;
            int n2 = string.lastIndexOf(46);
            if (n2 != -1 && (securityManager = System.getSecurityManager()) != null) {
                securityManager.checkPackageAccess(string.substring(0, n2));
            }
            return super.loadClass(string, bl2);
        }

        protected void addInstrumentationURL(URL uRL) {
            super.addURL(uRL);
        }

        protected PermissionCollection getPermissions(CodeSource codeSource) {
            PermissionCollection permissionCollection = super.getPermissions(codeSource);
            permissionCollection.add(new RuntimePermission("exitVM"));
            return permissionCollection;
        }

        private static AccessControlContext getContext(File[] fileArray) throws MalformedURLException {
            PathPermissions pathPermissions = new PathPermissions(fileArray);
            ProtectionDomain protectionDomain = new ProtectionDomain(new CodeSource(pathPermissions.getCodeBase(), (Certificate[])null), pathPermissions);
            AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{protectionDomain});
            return accessControlContext;
        }
    }

    static class ExtClassLoader
    extends URLClassLoader {
        private File[] dirs;

        public static ExtClassLoader getExtClassLoader() throws IOException {
            final File[] fileArray = ExtClassLoader.getExtDirs();
            try {
                return (ExtClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new ExtClassLoader(fileArray);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }

        void addExtURL(URL uRL) {
            super.addURL(uRL);
        }

        public ExtClassLoader(File[] fileArray) throws IOException {
            super(ExtClassLoader.getExtURLs(fileArray), null, factory);
            this.dirs = fileArray;
        }

        private static File[] getExtDirs() {
            File[] fileArray;
            String string = System.getProperty("java.ext.dirs");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
                int n2 = stringTokenizer.countTokens();
                fileArray = new File[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    fileArray[i2] = new File(stringTokenizer.nextToken());
                }
            } else {
                fileArray = new File[]{};
            }
            return fileArray;
        }

        private static URL[] getExtURLs(File[] fileArray) throws IOException {
            Vector<URL> vector = new Vector<URL>();
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                String[] stringArray = fileArray[i2].list();
                if (stringArray == null) continue;
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    File file = new File(fileArray[i2], stringArray[i3]);
                    vector.add(Launcher.getFileURL(file));
                }
            }
            Object[] objectArray = new URL[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        public String findLibrary(String string) {
            string = System.mapLibraryName(string);
            for (int i2 = 0; i2 < this.dirs.length; ++i2) {
                File file;
                String string2 = System.getProperty("os.arch");
                if (string2 != null && (file = new File(new File(this.dirs[i2], string2), string)).exists()) {
                    return file.getAbsolutePath();
                }
                file = new File(this.dirs[i2], string);
                if (!file.exists()) continue;
                return file.getAbsolutePath();
            }
            return null;
        }

        private static AccessControlContext getContext(File[] fileArray) throws IOException {
            PathPermissions pathPermissions = new PathPermissions(fileArray);
            ProtectionDomain protectionDomain = new ProtectionDomain(new CodeSource(pathPermissions.getCodeBase(), (Certificate[])null), pathPermissions);
            AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{protectionDomain});
            return accessControlContext;
        }
    }

    private static class Factory
    implements URLStreamHandlerFactory {
        private static String PREFIX = "sun.net.www.protocol";

        private Factory() {
        }

        public URLStreamHandler createURLStreamHandler(String string) {
            String string2 = PREFIX + "." + string + ".Handler";
            try {
                Class<?> clazz = Class.forName(string2);
                return (URLStreamHandler)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            throw new InternalError("could not load " + string + "system protocol handler");
        }
    }
}

