/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import sun.misc.VMNotification;

public class VM {
    private static boolean suspended = false;
    public static final int STATE_GREEN = 1;
    public static final int STATE_YELLOW = 2;
    public static final int STATE_RED = 3;
    private static volatile boolean booted = false;
    private static long directMemory = 0x4000000L;
    private static boolean defaultAllowArraySyntax;
    private static boolean allowArraySyntax;
    private static volatile int finalRefCount;
    private static volatile int peakFinalRefCount;
    private static Map<Integer, Thread.State> threadStateMap;

    public static boolean threadsSuspended() {
        return suspended;
    }

    public static boolean allowThreadSuspension(ThreadGroup threadGroup, boolean bl2) {
        return threadGroup.allowThreadSuspension(bl2);
    }

    public static boolean suspendThreads() {
        suspended = true;
        return true;
    }

    public static void unsuspendThreads() {
        suspended = false;
    }

    public static void unsuspendSomeThreads() {
    }

    public static final int getState() {
        return 1;
    }

    public static void registerVMNotification(VMNotification vMNotification) {
    }

    public static void asChange(int n2, int n3) {
    }

    public static void asChange_otherthread(int n2, int n3) {
    }

    public static void booted() {
        booted = true;
    }

    public static boolean isBooted() {
        return booted;
    }

    public static long maxDirectMemory() {
        if (booted) {
            return directMemory;
        }
        Properties properties = System.getProperties();
        String string = (String)properties.remove("sun.nio.MaxDirectMemorySize");
        System.setProperties(properties);
        if (string != null) {
            if (string.equals("-1")) {
                directMemory = Runtime.getRuntime().maxMemory();
            } else {
                long l2 = Long.parseLong(string);
                if (l2 > -1L) {
                    directMemory = l2;
                }
            }
        }
        return directMemory;
    }

    public static boolean allowArraySyntax() {
        if (!booted) {
            String string = System.getProperty("sun.lang.ClassLoader.allowArraySyntax");
            allowArraySyntax = string == null ? defaultAllowArraySyntax : Boolean.parseBoolean(string);
        }
        return allowArraySyntax;
    }

    public static int getFinalRefCount() {
        return finalRefCount;
    }

    public static int getPeakFinalRefCount() {
        return peakFinalRefCount;
    }

    public static void addFinalRefCount(int n2) {
        if ((finalRefCount += n2) > peakFinalRefCount) {
            peakFinalRefCount = finalRefCount;
        }
    }

    public static void initThreadStates() {
        String[] stringArray;
        if (booted) {
            return;
        }
        Thread.State[] stateArray = Thread.State.values();
        String[] stringArray2 = new String[stateArray.length];
        boolean[] blArray = new boolean[stateArray.length];
        for (int i2 = 0; i2 < stateArray.length; ++i2) {
            stringArray2[i2] = "sun.lang.Thread.State." + stateArray[i2].name();
        }
        threadStateMap = new HashMap<Integer, Thread.State>();
        Properties properties = System.getProperties();
        for (String string : stringArray = properties.keySet().toArray(new String[0])) {
            if (!string.startsWith("sun.lang.Thread.State.")) continue;
            Thread.State state = null;
            for (int i3 = 0; i3 < stateArray.length; ++i3) {
                if (!string.startsWith(stringArray2[i3])) continue;
                state = stateArray[i3];
                blArray[i3] = true;
            }
            if (state == null) {
                throw new InternalError(string + " system property is unexpected by JDK");
            }
            Integer n2 = Integer.valueOf((String)properties.remove(string));
            threadStateMap.put(n2, state);
        }
        for (int i4 = 0; i4 < stateArray.length; ++i4) {
            if (blArray[i4]) continue;
        }
        System.setProperties(properties);
    }

    public static Thread.State toThreadState(int n2) {
        Thread.State state = threadStateMap.get(new Integer(n2));
        if (state == null) {
            state = Thread.State.RUNNABLE;
        }
        return state;
    }

    static {
        allowArraySyntax = defaultAllowArraySyntax = true;
        finalRefCount = 0;
        peakFinalRefCount = 0;
    }
}

