/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends OutputStream {
    static final int DEFAULT_CHUNK_SIZE = 4096;
    private byte[] buf;
    private int count;
    private OutputStream out;
    private int preferredChunkSize;

    private int headerSize(int n2) {
        return 2 + Integer.toHexString(n2).length();
    }

    public ChunkedOutputStream(OutputStream outputStream) {
        this(outputStream, 4096);
    }

    public ChunkedOutputStream(OutputStream outputStream, int n2) {
        this.out = outputStream;
        if (n2 <= 0) {
            n2 = 4096;
        }
        if (n2 > 0) {
            int n3 = n2 - this.headerSize(n2);
            if (n3 + this.headerSize(n3) < n2) {
                ++n3;
            }
            n2 = n3;
        }
        this.preferredChunkSize = n2 > 0 ? n2 : 4096 - this.headerSize(4096);
        this.buf = new byte[this.preferredChunkSize + 32];
    }

    private void flush(boolean bl2) throws IOException {
        do {
            int n2;
            if (this.count < this.preferredChunkSize) {
                if (!bl2) {
                    return;
                }
                n2 = this.count;
            } else {
                n2 = this.preferredChunkSize;
            }
            this.out.write(Integer.toHexString(n2).getBytes());
            this.out.write(13);
            this.out.write(10);
            if (n2 > 0) {
                this.out.write(this.buf, 0, n2);
                this.out.write(13);
                this.out.write(10);
            }
            this.out.flush();
            if (n2 <= 0) continue;
            if (this.count > n2) {
                System.arraycopy(this.buf, n2, this.buf, 0, this.count - n2);
            }
            this.count -= n2;
        } while (this.count > 0);
    }

    private void checkFlush() throws IOException {
        if (this.count >= this.preferredChunkSize) {
            this.flush(false);
        }
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    public synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.count + n3;
        if (n4 > this.buf.length) {
            byte[] byArray2 = new byte[Math.max(this.buf.length << 1, n4)];
            System.arraycopy(this.buf, 0, byArray2, 0, this.count);
            this.buf = byArray2;
        }
        System.arraycopy(byArray, n2, this.buf, this.count, n3);
        this.count = n4;
        this.checkFlush();
    }

    public synchronized void write(int n2) throws IOException {
        this.ensureOpen();
        int n3 = this.count + 1;
        if (n3 > this.buf.length) {
            byte[] byArray = new byte[Math.max(this.buf.length << 1, n3)];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        this.buf[this.count] = (byte)n2;
        this.count = n3;
        this.checkFlush();
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public synchronized void close() throws IOException {
        this.ensureOpen();
        if (this.count > 0) {
            this.flush(true);
        }
        this.flush(true);
        this.out = null;
    }

    public synchronized void flush() throws IOException {
        this.ensureOpen();
        if (this.count > 0) {
            this.flush(true);
        }
    }
}

