/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.CacheRequest;
import java.net.CookieHandler;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.misc.RegexpPool;
import sun.net.NetworkClient;
import sun.net.ProgressSource;
import sun.net.www.HeaderParser;
import sun.net.www.MessageHeader;
import sun.net.www.MeteredStream;
import sun.net.www.ParseUtil;
import sun.net.www.http.ChunkedInputStream;
import sun.net.www.http.KeepAliveCache;
import sun.net.www.http.KeepAliveStream;
import sun.net.www.http.PosterOutputStream;
import sun.net.www.protocol.http.HttpURLConnection;

public class HttpClient
extends NetworkClient {
    protected boolean cachedHttpClient = false;
    private boolean inCache;
    protected CookieHandler cookieHandler;
    MessageHeader requests;
    PosterOutputStream poster = null;
    boolean failedOnce = false;
    private static RegexpPool nonProxyHostsPool = null;
    private static String nonProxyHostsSource = null;
    private static final int HTTP_CONTINUE = 100;
    static final int httpPortNumber = 80;
    protected boolean proxyDisabled;
    public boolean usingProxy = false;
    protected String host;
    protected int port;
    protected static KeepAliveCache kac = new KeepAliveCache();
    private static boolean keepAliveProp = true;
    volatile boolean keepingAlive = false;
    int keepAliveConnections = -1;
    int keepAliveTimeout = 0;
    private CacheRequest cacheRequest = null;
    protected URL url;
    public boolean reuse = false;

    protected int getDefaultPort() {
        return 80;
    }

    private static int getDefaultPort(String string) {
        if ("http".equalsIgnoreCase(string)) {
            return 80;
        }
        if ("https".equalsIgnoreCase(string)) {
            return 443;
        }
        return -1;
    }

    public static synchronized void resetProperties() {
    }

    int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public boolean getHttpKeepAliveSet() {
        return keepAliveProp;
    }

    protected HttpClient() {
    }

    private HttpClient(URL uRL) throws IOException {
        this(uRL, null, -1, false);
    }

    protected HttpClient(URL uRL, boolean bl2) throws IOException {
        this(uRL, null, -1, bl2);
    }

    public HttpClient(URL uRL, String string, int n2) throws IOException {
        this(uRL, string, n2, false);
    }

    protected HttpClient(URL uRL, Proxy proxy, int n2) throws IOException {
        this.proxy = proxy == null ? Proxy.NO_PROXY : proxy;
        this.host = uRL.getHost();
        this.url = uRL;
        this.port = uRL.getPort();
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.setConnectTimeout(n2);
        this.cookieHandler = (CookieHandler)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return CookieHandler.getDefault();
            }
        });
        this.openServer();
    }

    protected static Proxy newHttpProxy(String string, int n2, String string2) {
        if (string == null || string2 == null) {
            return Proxy.NO_PROXY;
        }
        int n3 = n2 < 0 ? HttpClient.getDefaultPort(string2) : n2;
        InetSocketAddress inetSocketAddress = InetSocketAddress.createUnresolved(string, n3);
        return new Proxy(Proxy.Type.HTTP, inetSocketAddress);
    }

    private HttpClient(URL uRL, String string, int n2, boolean bl2) throws IOException {
        this(uRL, bl2 ? Proxy.NO_PROXY : HttpClient.newHttpProxy(string, n2, "http"), -1);
    }

    public HttpClient(URL uRL, String string, int n2, boolean bl2, int n3) throws IOException {
        this(uRL, bl2 ? Proxy.NO_PROXY : HttpClient.newHttpProxy(string, n2, "http"), n3);
    }

    public static HttpClient New(URL uRL) throws IOException {
        return HttpClient.New(uRL, Proxy.NO_PROXY, -1, true);
    }

    public static HttpClient New(URL uRL, boolean bl2) throws IOException {
        return HttpClient.New(uRL, Proxy.NO_PROXY, -1, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient New(URL uRL, Proxy proxy, int n2, boolean bl2) throws IOException {
        Object object;
        if (proxy == null) {
            proxy = Proxy.NO_PROXY;
        }
        HttpClient httpClient = null;
        if (bl2 && (httpClient = (HttpClient)kac.get(uRL, null)) != null && (httpClient.proxy != null && httpClient.proxy.equals(proxy) || httpClient.proxy == null && proxy == null)) {
            object = httpClient;
            synchronized (object) {
                httpClient.cachedHttpClient = true;
                assert (httpClient.inCache);
                httpClient.inCache = false;
            }
        }
        if (httpClient == null) {
            httpClient = new HttpClient(uRL, proxy, n2);
        } else {
            object = System.getSecurityManager();
            if (object != null) {
                ((SecurityManager)object).checkConnect(uRL.getHost(), uRL.getPort());
            }
            httpClient.url = uRL;
        }
        return httpClient;
    }

    public static HttpClient New(URL uRL, Proxy proxy, int n2) throws IOException {
        return HttpClient.New(uRL, proxy, n2, true);
    }

    public static HttpClient New(URL uRL, String string, int n2, boolean bl2) throws IOException {
        return HttpClient.New(uRL, HttpClient.newHttpProxy(string, n2, "http"), -1, bl2);
    }

    public static HttpClient New(URL uRL, String string, int n2, boolean bl2, int n3) throws IOException {
        return HttpClient.New(uRL, HttpClient.newHttpProxy(string, n2, "http"), n3, bl2);
    }

    public void finished() {
        if (this.reuse) {
            return;
        }
        --this.keepAliveConnections;
        if (this.keepAliveConnections > 0 && this.isKeepingAlive() && !this.serverOutput.checkError()) {
            this.putInKeepAliveCache();
        } else {
            this.closeServer();
        }
    }

    protected synchronized void putInKeepAliveCache() {
        if (this.inCache) {
            assert (false) : "Duplicate put to keep alive cache";
            return;
        }
        this.inCache = true;
        kac.put(this.url, null, this);
    }

    public void closeIdleConnection() {
        HttpClient httpClient = (HttpClient)kac.get(this.url, null);
        if (httpClient != null) {
            httpClient.closeServer();
        }
    }

    public void openServer(String string, int n2) throws IOException {
        this.serverSocket = this.doConnect(string, n2);
        try {
            this.serverOutput = new PrintStream(new BufferedOutputStream(this.serverSocket.getOutputStream()), false, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(encoding + " encoding not found");
        }
        this.serverSocket.setTcpNoDelay(true);
    }

    public boolean needsTunneling() {
        return false;
    }

    public boolean isCachedConnection() {
        return this.cachedHttpClient;
    }

    public void afterConnect() throws IOException, UnknownHostException {
    }

    private synchronized void privilegedOpenServer(final InetSocketAddress inetSocketAddress) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    HttpClient.this.openServer(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void superOpenServer(String string, int n2) throws IOException, UnknownHostException {
        super.openServer(string, n2);
    }

    private synchronized void privilegedSuperOpenServer(final String string, final int n2) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    HttpClient.this.superOpenServer(string, n2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    protected synchronized void openServer() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.host, this.port);
        }
        if (this.keepingAlive) {
            return;
        }
        String string = this.url.getHost().toLowerCase();
        if (this.url.getProtocol().equals("http") || this.url.getProtocol().equals("https")) {
            if (this.proxy != null && this.proxy.type() == Proxy.Type.HTTP) {
                this.privilegedOpenServer((InetSocketAddress)this.proxy.address());
                this.usingProxy = true;
                return;
            }
            this.openServer(this.host, this.port);
            this.usingProxy = false;
            return;
        }
        if (this.proxy != null && this.proxy.type() == Proxy.Type.HTTP) {
            this.privilegedOpenServer((InetSocketAddress)this.proxy.address());
            this.usingProxy = true;
            return;
        }
        super.openServer(this.host, this.port);
        this.usingProxy = false;
    }

    public String getURLFile() throws IOException {
        String string = this.url.getFile();
        if (string == null || string.length() == 0) {
            string = "/";
        }
        if (this.usingProxy && !this.proxyDisabled) {
            string = this.url.toExternalForm();
        }
        if (string.indexOf(10) == -1) {
            return string;
        }
        throw new MalformedURLException("Illegal character in URL");
    }

    public void writeRequests(MessageHeader messageHeader) {
        this.requests = messageHeader;
        this.requests.print(this.serverOutput);
        this.serverOutput.flush();
    }

    public void writeRequests(MessageHeader messageHeader, PosterOutputStream posterOutputStream) throws IOException {
        this.requests = messageHeader;
        this.requests.print(this.serverOutput);
        this.poster = posterOutputStream;
        if (this.poster != null) {
            this.poster.writeTo(this.serverOutput);
        }
        this.serverOutput.flush();
    }

    public boolean parseHTTP(MessageHeader messageHeader, ProgressSource progressSource, HttpURLConnection httpURLConnection) throws IOException {
        try {
            this.serverInput = this.serverSocket.getInputStream();
            this.serverInput = new BufferedInputStream(this.serverInput);
            return this.parseHTTPHeader(messageHeader, progressSource, httpURLConnection);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.closeServer();
            throw socketTimeoutException;
        }
        catch (IOException iOException) {
            this.closeServer();
            this.cachedHttpClient = false;
            if (!this.failedOnce && this.requests != null) {
                this.failedOnce = true;
                this.openServer();
                if (this.needsTunneling()) {
                    httpURLConnection.doTunneling();
                }
                this.afterConnect();
                this.writeRequests(this.requests, this.poster);
                return this.parseHTTP(messageHeader, progressSource, httpURLConnection);
            }
            throw iOException;
        }
    }

    public int setTimeout(int n2) throws SocketException {
        int n3 = this.serverSocket.getSoTimeout();
        this.serverSocket.setSoTimeout(n2);
        return n3;
    }

    private boolean parseHTTPHeader(MessageHeader messageHeader, ProgressSource progressSource, HttpURLConnection httpURLConnection) throws IOException {
        int n2;
        int n3;
        this.keepAliveConnections = -1;
        this.keepAliveTimeout = 0;
        boolean bl2 = false;
        byte[] byArray = new byte[8];
        this.serverInput.mark(10);
        for (n2 = 0; n2 < 8 && (n3 = this.serverInput.read(byArray, n2, 8 - n2)) >= 0; n2 += n3) {
        }
        String string = null;
        bl2 = byArray[0] == 72 && byArray[1] == 84 && byArray[2] == 84 && byArray[3] == 80 && byArray[4] == 47 && byArray[5] == 49 && byArray[6] == 46;
        this.serverInput.reset();
        if (bl2) {
            Object object;
            messageHeader.parseHeader(this.serverInput);
            if (this.cookieHandler != null && (object = ParseUtil.toURI(this.url)) != null) {
                this.cookieHandler.put((URI)object, messageHeader.getHeaders());
            }
            if (this.usingProxy) {
                string = messageHeader.findValue("Proxy-Connection");
            }
            if (string == null) {
                string = messageHeader.findValue("Connection");
            }
            if (string != null && string.toLowerCase().equals("keep-alive")) {
                object = new HeaderParser(messageHeader.findValue("Keep-Alive"));
                if (object != null) {
                    this.keepAliveConnections = ((HeaderParser)object).findInt("max", this.usingProxy ? 50 : 5);
                    this.keepAliveTimeout = ((HeaderParser)object).findInt("timeout", this.usingProxy ? 60 : 5);
                }
            } else if (byArray[7] != 48) {
                this.keepAliveConnections = string != null ? 1 : 5;
            }
        } else {
            if (n2 != 8) {
                if (!this.failedOnce && this.requests != null) {
                    this.failedOnce = true;
                    this.closeServer();
                    this.cachedHttpClient = false;
                    this.openServer();
                    if (this.needsTunneling()) {
                        httpURLConnection.doTunneling();
                    }
                    this.afterConnect();
                    this.writeRequests(this.requests, this.poster);
                    return this.parseHTTP(messageHeader, progressSource, httpURLConnection);
                }
                throw new SocketException("Unexpected end of file from server");
            }
            messageHeader.set("Content-type", "unknown/unknown");
        }
        n2 = -1;
        try {
            string = messageHeader.getValue(0);
            int n4 = string.indexOf(32);
            while (string.charAt(n4) == ' ') {
                ++n4;
            }
            n2 = Integer.parseInt(string.substring(n4, n4 + 3));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 == 100) {
            messageHeader.reset();
            return this.parseHTTPHeader(messageHeader, progressSource, httpURLConnection);
        }
        int n5 = -1;
        String string2 = null;
        try {
            string2 = messageHeader.findValue("Transfer-Encoding");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 != null && string2.equalsIgnoreCase("chunked")) {
            this.serverInput = new ChunkedInputStream(this.serverInput, this, messageHeader);
            if (this.keepAliveConnections < 0) {
                this.keepAliveConnections = 1;
            }
            this.keepingAlive = true;
            this.failedOnce = false;
        } else {
            try {
                n5 = Integer.parseInt(messageHeader.findValue("content-length"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.keepAliveConnections > 1 && (n5 >= 0 || n2 == 304 || n2 == 204)) {
                this.keepingAlive = true;
                this.failedOnce = false;
            } else if (this.keepingAlive) {
                this.keepingAlive = false;
            }
        }
        if (n5 > 0) {
            if (progressSource != null) {
                progressSource.setContentType(messageHeader.findValue("content-type"));
            }
            if (this.isKeepingAlive()) {
                this.serverInput = new KeepAliveStream(this.serverInput, progressSource, n5, this);
                this.failedOnce = false;
            } else {
                this.serverInput = new MeteredStream(this.serverInput, progressSource, n5);
            }
        } else if (n5 == -1) {
            if (progressSource != null) {
                progressSource.setContentType(messageHeader.findValue("content-type"));
                this.serverInput = new MeteredStream(this.serverInput, progressSource, n5);
            }
        } else if (progressSource != null) {
            progressSource.finishTracking();
        }
        return bl2;
    }

    public synchronized InputStream getInputStream() {
        return this.serverInput;
    }

    public OutputStream getOutputStream() {
        return this.serverOutput;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.url + ")";
    }

    public final boolean isKeepingAlive() {
        return this.getHttpKeepAliveSet() && this.keepingAlive;
    }

    public void setCacheRequest(CacheRequest cacheRequest) {
        this.cacheRequest = cacheRequest;
    }

    CacheRequest getCacheRequest() {
        return this.cacheRequest;
    }

    protected void finalize() throws Throwable {
    }

    public void closeServer() {
        try {
            this.keepingAlive = false;
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getProxyHostUsed() {
        if (!this.usingProxy) {
            return null;
        }
        return ((InetSocketAddress)this.proxy.address()).getHostName();
    }

    public int getProxyPortUsed() {
        if (this.usingProxy) {
            return ((InetSocketAddress)this.proxy.address()).getPort();
        }
        return -1;
    }

    static {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("http.keepAlive");
            }
        });
        keepAliveProp = string != null ? Boolean.valueOf(string) : true;
    }
}

