/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.gopher;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.AccessController;
import sun.net.NetworkClient;
import sun.net.www.MessageHeader;
import sun.net.www.URLConnection;
import sun.net.www.protocol.gopher.GopherInputStream;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class GopherClient
extends NetworkClient
implements Runnable {
    public static boolean useGopherProxy;
    public static String gopherProxyHost;
    public static int gopherProxyPort;
    PipedOutputStream os;
    URL u;
    int gtype;
    String gkey;
    URLConnection connection;

    GopherClient(URLConnection uRLConnection) {
        this.connection = uRLConnection;
    }

    public static boolean getUseGopherProxy() {
        return (Boolean)AccessController.doPrivileged(new GetBooleanAction("gopherProxySet"));
    }

    public static String getGopherProxyHost() {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("gopherProxyHost"));
        if ("".equals(string)) {
            string = null;
        }
        return string;
    }

    public static int getGopherProxyPort() {
        return (Integer)AccessController.doPrivileged(new GetIntegerAction("gopherProxyPort", 80));
    }

    InputStream openStream(URL uRL) throws IOException {
        int n2;
        this.u = uRL;
        this.os = this.os;
        String string = uRL.getFile();
        int n3 = string.length();
        int n4 = 49;
        for (n2 = 0; n2 < n3; ++n2) {
            char c2 = string.charAt(n2);
            n4 = c2;
            if (c2 != '/') break;
        }
        int n5 = this.gtype = n4 == 47 ? 49 : n4;
        if (n2 < n3) {
            ++n2;
        }
        this.gkey = string.substring(n2);
        this.openServer(uRL.getHost(), uRL.getPort() <= 0 ? 70 : uRL.getPort());
        MessageHeader messageHeader = new MessageHeader();
        switch (this.gtype) {
            case 48: 
            case 55: {
                messageHeader.add("content-type", "text/plain");
                break;
            }
            case 49: {
                messageHeader.add("content-type", "text/html");
                break;
            }
            case 73: 
            case 103: {
                messageHeader.add("content-type", "image/gif");
                break;
            }
            default: {
                messageHeader.add("content-type", "content/unknown");
            }
        }
        if (this.gtype != 55) {
            this.serverOutput.print(this.decodePercent(this.gkey) + "\r\n");
            this.serverOutput.flush();
        } else {
            n2 = this.gkey.indexOf(63);
            if (n2 >= 0) {
                this.serverOutput.print(this.decodePercent(this.gkey.substring(0, n2) + "\t" + this.gkey.substring(n2 + 1) + "\r\n"));
                this.serverOutput.flush();
                messageHeader.add("content-type", "text/html");
            } else {
                messageHeader.add("content-type", "text/html");
            }
        }
        this.connection.setProperties(messageHeader);
        if (messageHeader.findValue("content-type") == "text/html") {
            this.os = new PipedOutputStream();
            PipedInputStream pipedInputStream = new PipedInputStream();
            pipedInputStream.connect(this.os);
            new Thread(this).start();
            return pipedInputStream;
        }
        return new GopherInputStream(this, this.serverInput);
    }

    private String decodePercent(String string) {
        if (string == null || string.indexOf(37) < 0) {
            return string;
        }
        int n2 = string.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = string.charAt(i2);
            if (n4 == 37 && i2 + 2 < n2) {
                int n5 = string.charAt(i2 + 1);
                int n6 = string.charAt(i2 + 2);
                n5 = 48 <= n5 && n5 <= 57 ? (n5 -= 48) : (97 <= n5 && n5 <= 102 ? n5 - 97 + 10 : (65 <= n5 && n5 <= 70 ? n5 - 65 + 10 : -1));
                n6 = 48 <= n6 && n6 <= 57 ? (n6 -= 48) : (97 <= n6 && n6 <= 102 ? n6 - 97 + 10 : (65 <= n6 && n6 <= 70 ? n6 - 65 + 10 : -1));
                if (n5 >= 0 && n6 >= 0) {
                    n4 = n5 << 4 | n6;
                    i2 += 2;
                }
            }
            cArray[n3++] = (char)n4;
        }
        return new String(cArray, 0, n3);
    }

    private String encodePercent(String string) {
        if (string == null) {
            return string;
        }
        int n2 = string.length();
        char[] cArray = null;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 <= ' ' || c2 == '\"' || c2 == '%') {
                if (cArray == null) {
                    cArray = string.toCharArray();
                }
                if (n3 + 3 >= cArray.length) {
                    char[] cArray2 = new char[n3 + 10];
                    System.arraycopy(cArray, 0, cArray2, 0, n3);
                    cArray = cArray2;
                }
                cArray[n3] = 37;
                int n4 = c2 >> 4 & 0xF;
                cArray[n3 + 1] = (char)(n4 < 10 ? 48 + n4 : 55 + n4);
                n4 = c2 & 0xF;
                cArray[n3 + 2] = (char)(n4 < 10 ? 48 + n4 : 55 + n4);
                n3 += 3;
                continue;
            }
            if (cArray != null) {
                if (n3 >= cArray.length) {
                    char[] cArray3 = new char[n3 + 10];
                    System.arraycopy(cArray, 0, cArray3, 0, n3);
                    cArray = cArray3;
                }
                cArray[n3] = c2;
            }
            ++n3;
        }
        return cArray == null ? string : new String(cArray, 0, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block24: {
            int n2 = -1;
            try {
                String string;
                if (this.gtype == 55 && (n2 = this.gkey.indexOf(63)) < 0) {
                    PrintStream printStream = new PrintStream(this.os, false, encoding);
                    printStream.print("<html><head><title>Searchable Gopher Index</title></head>\n<body><h1>Searchable Gopher Index</h1><isindex>\n</body></html>\n");
                    break block24;
                }
                if (this.gtype != 49 && this.gtype != 55) {
                    byte[] byArray = new byte[2048];
                    try {
                        int n3;
                        while ((n3 = this.serverInput.read(byArray)) >= 0) {
                            this.os.write(byArray, 0, n3);
                        }
                        break block24;
                    }
                    catch (Exception exception) {
                        break block24;
                    }
                }
                PrintStream printStream = new PrintStream(this.os, false, encoding);
                String string2 = null;
                string2 = this.gtype == 55 ? "Results of searching for \"" + this.gkey.substring(n2 + 1) + "\" on " + this.u.getHost() : "Gopher directory " + this.gkey + " from " + this.u.getHost();
                printStream.print("<html><head><title>");
                printStream.print(string2);
                printStream.print("</title></head>\n<body>\n<H1>");
                printStream.print(string2);
                printStream.print("</h1><dl compact>\n");
                DataInputStream dataInputStream = new DataInputStream(this.serverInput);
                while ((string = dataInputStream.readLine()) != null) {
                    int n4;
                    for (n4 = string.length(); n4 > 0 && string.charAt(n4 - 1) <= ' '; --n4) {
                    }
                    if (n4 <= 0) continue;
                    char c2 = string.charAt(0);
                    int n5 = string.indexOf(9);
                    int n6 = n5 > 0 ? string.indexOf(9, n5 + 1) : -1;
                    int n7 = n6 > 0 ? string.indexOf(9, n6 + 1) : -1;
                    if (n7 < 0) continue;
                    String string3 = n7 + 1 < n4 ? ":" + string.substring(n7 + 1, n4) : "";
                    String string4 = n6 + 1 < n7 ? string.substring(n6 + 1, n7) : this.u.getHost();
                    printStream.print("<dt><a href=\"gopher://" + string4 + string3 + "/" + string.substring(0, 1) + this.encodePercent(string.substring(n5 + 1, n6)) + "\">\n");
                    printStream.print("<img align=middle border=0 width=25 height=32 src=");
                    switch (c2) {
                        default: {
                            printStream.print(System.getProperty("java.net.ftp.imagepath.file"));
                            break;
                        }
                        case '0': {
                            printStream.print(System.getProperty("java.net.ftp.imagepath.text"));
                            break;
                        }
                        case '1': {
                            printStream.print(System.getProperty("java.net.ftp.imagepath.directory"));
                            break;
                        }
                        case 'g': {
                            printStream.print(System.getProperty("java.net.ftp.imagepath.gif"));
                        }
                    }
                    printStream.print(".gif align=middle><dd>\n");
                    printStream.print(string.substring(1, n5) + "</a>\n");
                }
                printStream.print("</dl></body>\n");
                printStream.close();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError(encoding + " encoding not found");
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this.closeServer();
                    this.os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new GetBooleanAction("gopherProxySet"));
        useGopherProxy = bl2;
        gopherProxyHost = (String)AccessController.doPrivileged(new GetPropertyAction("gopherProxyHost"));
        gopherProxyPort = (Integer)AccessController.doPrivileged(new GetIntegerAction("gopherProxyPort", 80));
    }
}

