/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.reflectiveObjects;

import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterizedTypeImpl
implements ParameterizedType {
    private Type[] actualTypeArguments;
    private Class<?> rawType;
    private Type ownerType;

    private ParameterizedTypeImpl(Class<?> clazz, Type[] typeArray, Type type) {
        this.actualTypeArguments = typeArray;
        this.rawType = clazz;
        this.ownerType = type != null ? type : clazz.getDeclaringClass();
        this.validateConstructorArguments();
    }

    private void validateConstructorArguments() {
        TypeVariable<Class<?>>[] typeVariableArray = this.rawType.getTypeParameters();
        if (typeVariableArray.length != this.actualTypeArguments.length) {
            throw new MalformedParameterizedTypeException();
        }
        for (int i2 = 0; i2 < this.actualTypeArguments.length; ++i2) {
        }
    }

    public static ParameterizedTypeImpl make(Class<?> clazz, Type[] typeArray, Type type) {
        return new ParameterizedTypeImpl(clazz, typeArray, type);
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public Class<?> getRawType() {
        return this.rawType;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.ownerType != null) {
            if (this.ownerType instanceof Class) {
                stringBuilder.append(((Class)this.ownerType).getName());
            } else {
                stringBuilder.append(this.ownerType.toString());
            }
            stringBuilder.append(".");
            if (this.ownerType instanceof ParameterizedTypeImpl) {
                stringBuilder.append(this.rawType.getName().replace(((ParameterizedTypeImpl)this.ownerType).rawType.getName() + "$", ""));
            } else {
                stringBuilder.append(this.rawType.getName());
            }
        } else {
            stringBuilder.append(this.rawType.getName());
        }
        if (this.actualTypeArguments != null && this.actualTypeArguments.length > 0) {
            stringBuilder.append("<");
            boolean bl2 = true;
            for (Type type : this.actualTypeArguments) {
                if (!bl2) {
                    stringBuilder.append(", ");
                }
                if (type instanceof Class) {
                    stringBuilder.append(((Class)type).getName());
                } else {
                    stringBuilder.append(type.toString());
                }
                bl2 = false;
            }
            stringBuilder.append(">");
        }
        return stringBuilder.toString();
    }
}

