/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.reflectiveObjects;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.reflectiveObjects.LazyReflectiveObjectGenerator;
import sun.reflect.generics.tree.FieldTypeSignature;
import sun.reflect.generics.visitor.Reifier;

public class WildcardTypeImpl
extends LazyReflectiveObjectGenerator
implements WildcardType {
    private Type[] upperBounds;
    private Type[] lowerBounds;
    private FieldTypeSignature[] upperBoundASTs;
    private FieldTypeSignature[] lowerBoundASTs;

    private WildcardTypeImpl(FieldTypeSignature[] fieldTypeSignatureArray, FieldTypeSignature[] fieldTypeSignatureArray2, GenericsFactory genericsFactory) {
        super(genericsFactory);
        this.upperBoundASTs = fieldTypeSignatureArray;
        this.lowerBoundASTs = fieldTypeSignatureArray2;
    }

    public static WildcardTypeImpl make(FieldTypeSignature[] fieldTypeSignatureArray, FieldTypeSignature[] fieldTypeSignatureArray2, GenericsFactory genericsFactory) {
        return new WildcardTypeImpl(fieldTypeSignatureArray, fieldTypeSignatureArray2, genericsFactory);
    }

    private FieldTypeSignature[] getUpperBoundASTs() {
        assert (this.upperBounds == null);
        return this.upperBoundASTs;
    }

    private FieldTypeSignature[] getLowerBoundASTs() {
        assert (this.lowerBounds == null);
        return this.lowerBoundASTs;
    }

    public Type[] getUpperBounds() {
        if (this.upperBounds == null) {
            FieldTypeSignature[] fieldTypeSignatureArray = this.getUpperBoundASTs();
            Type[] typeArray = new Type[fieldTypeSignatureArray.length];
            for (int i2 = 0; i2 < fieldTypeSignatureArray.length; ++i2) {
                Reifier reifier = this.getReifier();
                fieldTypeSignatureArray[i2].accept(reifier);
                typeArray[i2] = reifier.getResult();
            }
            this.upperBounds = typeArray;
        }
        return this.upperBounds;
    }

    public Type[] getLowerBounds() {
        if (this.lowerBounds == null) {
            FieldTypeSignature[] fieldTypeSignatureArray = this.getLowerBoundASTs();
            Type[] typeArray = new Type[fieldTypeSignatureArray.length];
            for (int i2 = 0; i2 < fieldTypeSignatureArray.length; ++i2) {
                Reifier reifier = this.getReifier();
                fieldTypeSignatureArray[i2].accept(reifier);
                typeArray[i2] = reifier.getResult();
            }
            this.lowerBounds = typeArray;
        }
        return this.lowerBounds;
    }

    public String toString() {
        Type[] typeArray;
        Type[] typeArray2 = typeArray = this.getLowerBounds();
        StringBuilder stringBuilder = new StringBuilder();
        if (typeArray.length > 0) {
            stringBuilder.append("? super ");
        } else {
            Type[] typeArray3 = this.getUpperBounds();
            if (typeArray3.length > 0 && !typeArray3[0].equals(Object.class)) {
                typeArray2 = typeArray3;
                stringBuilder.append("? extends ");
            } else {
                return "?";
            }
        }
        assert (typeArray2.length > 0);
        boolean bl2 = true;
        for (Type type : typeArray2) {
            if (!bl2) {
                stringBuilder.append(" & ");
            }
            bl2 = false;
            if (type instanceof Class) {
                stringBuilder.append(((Class)type).getName());
                continue;
            }
            stringBuilder.append(type.toString());
        }
        return stringBuilder.toString();
    }
}

