/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.LinkedHashMap;
import java.util.Map;
import sun.security.action.PutAllAction;
import sun.security.provider.NativePRNG;

public final class Sun
extends Provider {
    private static final long serialVersionUID = 6440182097568097204L;
    private static final String INFO = "SUN (DSA key/parameter generation; DSA signing; SHA-1, MD5 digests; SecureRandom; X.509 certificates; JKS keystore; PKIX CertPathValidator; PKIX CertPathBuilder; LDAP, Collection CertStores)";
    private static final String PROP_EGD = "java.security.egd";
    private static final String PROP_RNDSOURCE = "securerandom.source";
    static final String URL_DEV_RANDOM = "file:/dev/random";
    static final String URL_DEV_URANDOM = "file:/dev/urandom";
    private static final String seedSource;

    public Sun() {
        super("SUN", 1.5, INFO);
        Map<Object, Object> map = System.getSecurityManager() == null ? this : new LinkedHashMap();
        boolean bl2 = NativePRNG.isAvailable();
        boolean bl3 = seedSource.equals(URL_DEV_URANDOM);
        if (bl2 && bl3) {
            map.put("SecureRandom.NativePRNG", "sun.security.provider.NativePRNG");
        }
        map.put("SecureRandom.SHA1PRNG", "sun.security.provider.SecureRandom");
        if (bl2 && !bl3) {
            map.put("SecureRandom.NativePRNG", "sun.security.provider.NativePRNG");
        }
        map.put("Signature.SHA1withDSA", "sun.security.provider.DSA$SHA1withDSA");
        map.put("Signature.NONEwithDSA", "sun.security.provider.DSA$RawDSA");
        map.put("Alg.Alias.Signature.RawDSA", "NONEwithDSA");
        String string = "java.security.interfaces.DSAPublicKey|java.security.interfaces.DSAPrivateKey";
        map.put("Signature.SHA1withDSA SupportedKeyClasses", string);
        map.put("Signature.NONEwithDSA SupportedKeyClasses", string);
        map.put("Alg.Alias.Signature.DSA", "SHA1withDSA");
        map.put("Alg.Alias.Signature.DSS", "SHA1withDSA");
        map.put("Alg.Alias.Signature.SHA/DSA", "SHA1withDSA");
        map.put("Alg.Alias.Signature.SHA-1/DSA", "SHA1withDSA");
        map.put("Alg.Alias.Signature.SHA1/DSA", "SHA1withDSA");
        map.put("Alg.Alias.Signature.SHAwithDSA", "SHA1withDSA");
        map.put("Alg.Alias.Signature.DSAWithSHA1", "SHA1withDSA");
        map.put("Alg.Alias.Signature.OID.1.2.840.10040.4.3", "SHA1withDSA");
        map.put("Alg.Alias.Signature.1.2.840.10040.4.3", "SHA1withDSA");
        map.put("Alg.Alias.Signature.1.3.14.3.2.13", "SHA1withDSA");
        map.put("Alg.Alias.Signature.1.3.14.3.2.27", "SHA1withDSA");
        map.put("KeyPairGenerator.DSA", "sun.security.provider.DSAKeyPairGenerator");
        map.put("Alg.Alias.KeyPairGenerator.OID.1.2.840.10040.4.1", "DSA");
        map.put("Alg.Alias.KeyPairGenerator.1.2.840.10040.4.1", "DSA");
        map.put("Alg.Alias.KeyPairGenerator.1.3.14.3.2.12", "DSA");
        map.put("MessageDigest.MD2", "sun.security.provider.MD2");
        map.put("MessageDigest.MD5", "sun.security.provider.MD5");
        map.put("MessageDigest.SHA", "sun.security.provider.SHA");
        map.put("Alg.Alias.MessageDigest.SHA-1", "SHA");
        map.put("Alg.Alias.MessageDigest.SHA1", "SHA");
        map.put("MessageDigest.SHA-256", "sun.security.provider.SHA2");
        map.put("MessageDigest.SHA-384", "sun.security.provider.SHA5$SHA384");
        map.put("MessageDigest.SHA-512", "sun.security.provider.SHA5$SHA512");
        map.put("AlgorithmParameterGenerator.DSA", "sun.security.provider.DSAParameterGenerator");
        map.put("AlgorithmParameters.DSA", "sun.security.provider.DSAParameters");
        map.put("Alg.Alias.AlgorithmParameters.1.3.14.3.2.12", "DSA");
        map.put("Alg.Alias.AlgorithmParameters.1.2.840.10040.4.1", "DSA");
        map.put("KeyFactory.DSA", "sun.security.provider.DSAKeyFactory");
        map.put("Alg.Alias.KeyFactory.1.3.14.3.2.12", "DSA");
        map.put("Alg.Alias.KeyFactory.1.2.840.10040.4.1", "DSA");
        map.put("CertificateFactory.X.509", "sun.security.provider.X509Factory");
        map.put("Alg.Alias.CertificateFactory.X509", "X.509");
        map.put("KeyStore.JKS", "sun.security.provider.JavaKeyStore");
        map.put("CertPathBuilder.PKIX", "sun.security.provider.certpath.SunCertPathBuilder");
        map.put("CertPathBuilder.PKIX ValidationAlgorithm", "RFC3280");
        map.put("CertPathValidator.PKIX", "sun.security.provider.certpath.PKIXCertPathValidator");
        map.put("CertPathValidator.PKIX ValidationAlgorithm", "RFC3280");
        map.put("CertStore.LDAP", "sun.security.provider.certpath.LDAPCertStore");
        map.put("CertStore.LDAP LDAPSchema", "RFC2587");
        map.put("CertStore.Collection", "sun.security.provider.certpath.CollectionCertStore");
        map.put("CertStore.com.sun.security.IndexedCollection", "sun.security.provider.certpath.IndexedCollectionCertStore");
        map.put("Signature.SHA1withDSA KeySize", "1024");
        map.put("KeyPairGenerator.DSA KeySize", "1024");
        map.put("AlgorithmParameterGenerator.DSA KeySize", "1024");
        map.put("Signature.SHA1withDSA ImplementedIn", "Software");
        map.put("KeyPairGenerator.DSA ImplementedIn", "Software");
        map.put("MessageDigest.MD5 ImplementedIn", "Software");
        map.put("MessageDigest.SHA ImplementedIn", "Software");
        map.put("AlgorithmParameterGenerator.DSA ImplementedIn", "Software");
        map.put("AlgorithmParameters.DSA ImplementedIn", "Software");
        map.put("KeyFactory.DSA ImplementedIn", "Software");
        map.put("SecureRandom.SHA1PRNG ImplementedIn", "Software");
        map.put("CertificateFactory.X.509 ImplementedIn", "Software");
        map.put("KeyStore.JKS ImplementedIn", "Software");
        map.put("CertPathValidator.PKIX ImplementedIn", "Software");
        map.put("CertPathBuilder.PKIX ImplementedIn", "Software");
        map.put("CertStore.LDAP ImplementedIn", "Software");
        map.put("CertStore.Collection ImplementedIn", "Software");
        map.put("CertStore.com.sun.security.IndexedCollection ImplementedIn", "Software");
        if (map != this) {
            AccessController.doPrivileged(new PutAllAction(this, map));
        }
    }

    static String getSeedSource() {
        return seedSource;
    }

    static {
        Object t2 = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty(Sun.PROP_EGD, "");
                if (string.length() != 0) {
                    return string;
                }
                string = Security.getProperty(Sun.PROP_RNDSOURCE);
                if (string == null) {
                    return "";
                }
                return string;
            }
        });
        seedSource = (String)t2;
    }
}

