/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.ZoneInfoFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoneInfo
extends TimeZone {
    private static final int UTC_TIME = 0;
    private static final int STANDARD_TIME = 1;
    private static final int WALL_TIME = 2;
    private static final long OFFSET_MASK = 15L;
    private static final long DST_MASK = 240L;
    private static final int DST_NSHIFT = 4;
    private static final long ABBR_MASK = 3840L;
    private static final int TRANSITION_NSHIFT = 12;
    private static final CalendarSystem gcal = CalendarSystem.getGregorianCalendar();
    private int rawOffset;
    private int rawOffsetDiff = 0;
    private int checksum;
    private int dstSavings;
    private long[] transitions;
    private int[] offsets;
    private int[] simpleTimeZoneParams;
    private boolean willGMTOffsetChange = false;
    private transient boolean dirty = false;
    private static final long serialVersionUID = 2653134537216586139L;
    private transient SimpleTimeZone lastRule;
    private static SoftReference<Map> aliasTable;

    public ZoneInfo() {
    }

    public ZoneInfo(String string, int n2) {
        this(string, n2, 0, 0, null, null, null, false);
    }

    ZoneInfo(String string, int n2, int n3, int n4, long[] lArray, int[] nArray, int[] nArray2, boolean bl2) {
        this.setID(string);
        this.rawOffset = n2;
        this.dstSavings = n3;
        this.checksum = n4;
        this.transitions = lArray;
        this.offsets = nArray;
        this.simpleTimeZoneParams = nArray2;
        this.willGMTOffsetChange = bl2;
    }

    @Override
    public int getOffset(long l2) {
        return this.getOffsets(l2, null, 0);
    }

    public int getOffsets(long l2, int[] nArray) {
        return this.getOffsets(l2, nArray, 0);
    }

    public int getOffsetsByStandard(long l2, int[] nArray) {
        return this.getOffsets(l2, nArray, 1);
    }

    public int getOffsetsByWall(long l2, int[] nArray) {
        return this.getOffsets(l2, nArray, 2);
    }

    private int getOffsets(long l2, int[] nArray, int n2) {
        if (this.transitions == null) {
            int n3 = this.getLastRawOffset();
            if (nArray != null) {
                nArray[0] = n3;
                nArray[1] = 0;
            }
            return n3;
        }
        int n4 = this.getTransitionIndex(l2 -= (long)this.rawOffsetDiff, n2);
        if (n4 < 0) {
            int n5 = this.getLastRawOffset();
            if (nArray != null) {
                nArray[0] = n5;
                nArray[1] = 0;
            }
            return n5;
        }
        if (n4 < this.transitions.length) {
            long l3 = this.transitions[n4];
            int n6 = this.offsets[(int)(l3 & 0xFL)] + this.rawOffsetDiff;
            if (nArray != null) {
                int n7 = (int)(l3 >>> 4 & 0xFL);
                int n8 = n7 == 0 ? 0 : this.offsets[n7];
                nArray[0] = n6 - n8;
                nArray[1] = n8;
            }
            return n6;
        }
        SimpleTimeZone simpleTimeZone = this.getLastRule();
        if (simpleTimeZone != null) {
            int n9;
            int n10 = simpleTimeZone.getRawOffset();
            long l4 = l2;
            if (n2 != 0) {
                l4 -= (long)this.rawOffset;
            }
            int n11 = n9 = simpleTimeZone.inDaylightTime(new Date(l4)) ? simpleTimeZone.getDSTSavings() : 0;
            if (nArray != null) {
                nArray[0] = n10;
                nArray[1] = n9;
            }
            return n10 + n9;
        }
        int n12 = this.getLastRawOffset();
        if (nArray != null) {
            nArray[0] = n12;
            nArray[1] = 0;
        }
        return n12;
    }

    private final int getTransitionIndex(long l2, int n2) {
        int n3 = 0;
        int n4 = this.transitions.length - 1;
        while (n3 <= n4) {
            int n5;
            int n6 = (n3 + n4) / 2;
            long l3 = this.transitions[n6];
            long l4 = l3 >> 12;
            if (n2 != 0) {
                l4 += (long)this.offsets[(int)(l3 & 0xFL)];
            }
            if (n2 == 1 && (n5 = (int)(l3 >>> 4 & 0xFL)) != 0) {
                l4 -= (long)this.offsets[n5];
            }
            if (l4 < l2) {
                n3 = n6 + 1;
                continue;
            }
            if (l4 > l2) {
                n4 = n6 - 1;
                continue;
            }
            return n6;
        }
        if (n3 >= this.transitions.length) {
            return n3;
        }
        return n3 - 1;
    }

    @Override
    public int getOffset(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n7 < 0 || n7 >= 86400000) {
            throw new IllegalArgumentException();
        }
        if (n2 == 0) {
            n3 = 1 - n3;
        } else if (n2 != 1) {
            throw new IllegalArgumentException();
        }
        CalendarDate calendarDate = gcal.newCalendarDate(null);
        calendarDate.setDate(n3, n4 + 1, n5);
        if (!gcal.validate(calendarDate)) {
            throw new IllegalArgumentException();
        }
        if (n6 < 1 || n6 > 7) {
            throw new IllegalArgumentException();
        }
        if (this.transitions == null) {
            return this.getLastRawOffset();
        }
        long l2 = gcal.getTime(calendarDate) + (long)n7;
        return this.getOffsets(l2 -= (long)this.rawOffset, null, 0);
    }

    @Override
    public synchronized void setRawOffset(int n2) {
        if (n2 == this.rawOffset + this.rawOffsetDiff) {
            return;
        }
        this.rawOffsetDiff = n2 - this.rawOffset;
        if (this.lastRule != null) {
            this.lastRule.setRawOffset(n2);
        }
        this.dirty = true;
    }

    @Override
    public int getRawOffset() {
        if (!this.willGMTOffsetChange) {
            return this.rawOffset + this.rawOffsetDiff;
        }
        int[] nArray = new int[2];
        this.getOffsets(System.currentTimeMillis(), nArray, 0);
        return nArray[0];
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private int getLastRawOffset() {
        return this.rawOffset + this.rawOffsetDiff;
    }

    @Override
    public boolean useDaylightTime() {
        return this.simpleTimeZoneParams != null;
    }

    @Override
    public boolean inDaylightTime(Date date) {
        if (date == null) {
            throw new NullPointerException();
        }
        if (this.transitions == null) {
            return false;
        }
        long l2 = date.getTime() - (long)this.rawOffsetDiff;
        int n2 = this.getTransitionIndex(l2, 0);
        if (n2 < 0) {
            return false;
        }
        if (n2 < this.transitions.length) {
            return (this.transitions[n2] & 0xF0L) != 0L;
        }
        SimpleTimeZone simpleTimeZone = this.getLastRule();
        if (simpleTimeZone != null) {
            return simpleTimeZone.inDaylightTime(date);
        }
        return false;
    }

    @Override
    public int getDSTSavings() {
        return this.dstSavings;
    }

    public String toString() {
        return this.getClass().getName() + "[id=\"" + this.getID() + "\"" + ",offset=" + this.getLastRawOffset() + ",dstSavings=" + this.dstSavings + ",useDaylight=" + this.useDaylightTime() + ",transitions=" + (this.transitions != null ? this.transitions.length : 0) + ",lastRule=" + (this.lastRule == null ? this.getLastRuleInstance() : this.lastRule) + "]";
    }

    public static String[] getAvailableIDs() {
        return ZoneInfoFile.getZoneIDs();
    }

    public static String[] getAvailableIDs(int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = ZoneInfo.getAvailableIDs();
        int[] nArray = ZoneInfoFile.getRawOffsets();
        block0: for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] != n2) continue;
            byte[] byArray = ZoneInfoFile.getRawOffsetIndices();
            for (int i3 = 0; i3 < byArray.length; ++i3) {
                if (byArray[i3] != i2) continue;
                arrayList.add(stringArray[i3++]);
                while (i3 < byArray.length && byArray[i3] == i2) {
                    arrayList.add(stringArray[i3++]);
                }
                break block0;
            }
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    public static TimeZone getTimeZone(String string) {
        ZoneInfo zoneInfo = null;
        zoneInfo = ZoneInfoFile.getZoneInfo(string);
        if (zoneInfo == null) {
            try {
                Map<String, String> map = ZoneInfo.getAliasTable();
                String string2 = string;
                while ((string2 = map.get(string2)) != null) {
                    zoneInfo = ZoneInfoFile.getZoneInfo(string2);
                    if (zoneInfo == null) continue;
                    zoneInfo.setID(string);
                    zoneInfo = ZoneInfoFile.addToCache(string, zoneInfo);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return zoneInfo;
    }

    private synchronized SimpleTimeZone getLastRule() {
        if (this.lastRule == null) {
            this.lastRule = this.getLastRuleInstance();
        }
        return this.lastRule;
    }

    public SimpleTimeZone getLastRuleInstance() {
        if (this.simpleTimeZoneParams == null) {
            return null;
        }
        if (this.simpleTimeZoneParams.length == 10) {
            return new SimpleTimeZone(this.getLastRawOffset(), this.getID(), this.simpleTimeZoneParams[0], this.simpleTimeZoneParams[1], this.simpleTimeZoneParams[2], this.simpleTimeZoneParams[3], this.simpleTimeZoneParams[4], this.simpleTimeZoneParams[5], this.simpleTimeZoneParams[6], this.simpleTimeZoneParams[7], this.simpleTimeZoneParams[8], this.simpleTimeZoneParams[9], this.dstSavings);
        }
        return new SimpleTimeZone(this.getLastRawOffset(), this.getID(), this.simpleTimeZoneParams[0], this.simpleTimeZoneParams[1], this.simpleTimeZoneParams[2], this.simpleTimeZoneParams[3], this.simpleTimeZoneParams[4], this.simpleTimeZoneParams[5], this.simpleTimeZoneParams[6], this.simpleTimeZoneParams[7], this.dstSavings);
    }

    @Override
    public Object clone() {
        ZoneInfo zoneInfo = (ZoneInfo)super.clone();
        zoneInfo.lastRule = null;
        return zoneInfo;
    }

    public int hashCode() {
        return this.getLastRawOffset() ^ this.checksum;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ZoneInfo)) {
            return false;
        }
        ZoneInfo zoneInfo = (ZoneInfo)object;
        return this.getID().equals(zoneInfo.getID()) && this.getLastRawOffset() == zoneInfo.getLastRawOffset() && this.checksum == zoneInfo.checksum;
    }

    @Override
    public boolean hasSameRules(TimeZone timeZone) {
        if (this == timeZone) {
            return true;
        }
        if (timeZone == null) {
            return false;
        }
        if (!(timeZone instanceof ZoneInfo)) {
            if (this.getRawOffset() != timeZone.getRawOffset()) {
                return false;
            }
            return this.transitions == null && !this.useDaylightTime() && !timeZone.useDaylightTime();
        }
        if (this.getLastRawOffset() != ((ZoneInfo)timeZone).getLastRawOffset()) {
            return false;
        }
        return this.checksum == ((ZoneInfo)timeZone).checksum;
    }

    private static synchronized Map<String, String> getAliasTable() {
        Map map = null;
        SoftReference<Map> softReference = aliasTable;
        if (softReference != null && (map = softReference.get()) != null) {
            return map;
        }
        map = ZoneInfoFile.getZoneAliases();
        if (map != null) {
            aliasTable = new SoftReference<Map>(map);
        }
        return map;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.dirty = true;
    }
}

