/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.navig.motif;

import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.plugin.AppletViewer;
import sun.plugin.JavaRunTime;
import sun.plugin.navig.motif.MotifAppletContext;
import sun.plugin.navig.motif.MotifAppletViewer;
import sun.plugin.navig.motif.MotifBeansViewer;
import sun.plugin.navig.motif.OJIPlugin;
import sun.plugin.navig.motif.Worker;

public class Plugin
extends JavaRunTime {
    private static Hashtable panels = new Hashtable();
    private static int nextId = 0;
    private static boolean tracing;
    private static PrintStream printOut;
    private static DataOutputStream cmdOut;
    private static DataInputStream cmdIn;
    private static Worker worker;
    private static boolean alive;
    private static String proxyInfo;
    private static int proxyType;
    private static String proxyOverrides;
    private static int navig_version;
    private static ResourceBundle rb;
    private static FileWriter tracefile;
    private static String messages;
    public static final int CmdFD = 11;
    public static final int WorkFD = 12;
    public static final int PrintFD = 13;
    public static OJIPlugin oji;
    public static final int JAVA_PLUGIN_NEW = 16384001;
    public static final int JAVA_PLUGIN_DESTROY = 16384002;
    public static final int JAVA_PLUGIN_WINDOW = 16384003;
    public static final int JAVA_PLUGIN_SHUTDOWN = 16384004;
    public static final int JAVA_PLUGIN_DOCBASE = 16384005;
    public static final int JAVA_PLUGIN_PROXMAP_READY = 16384006;
    public static final int JAVA_PLUGIN_PROXY_MAPPING = 16384007;
    public static final int JAVA_PLUGIN_COOKIE = 16384008;
    public static final int JAVA_PLUGIN_CACHED_FILE = 16384009;
    public static final int JAVA_PLUGIN_JAVASCRIPT_REPLY = 0xFA000A;
    public static final int JAVA_PLUGIN_JAVASCRIPT_END = 16384011;
    public static final int JAVA_PLUGIN_START = 16384017;
    public static final int JAVA_PLUGIN_STOP = 16384018;
    public static final int JAVA_PLUGIN_ATTACH_THREAD = 16384019;
    public static final int JAVA_PLUGIN_REQUEST_ABRUPTLY_TERMINATED = 16384020;
    public static final int JAVA_PLUGIN_GET_INSTANCE_JAVA_OBJECT = 16384021;
    public static final int JAVA_PLUGIN_PRINT = 16384022;
    public static final int JAVA_PLUGIN_HTTPS_GET_REPLY = 16384023;
    public static final int JAVA_PLUGIN_HTTPS_POST_REPLY = 16384024;
    public static final int JAVA_PLUGIN_CONSOLE_SHOW = 16384025;
    public static final int JAVA_PLUGIN_CONSOLE_HIDE = 16384026;
    public static final int JAVA_PLUGIN_CONSOLE_PRINT = 16384027;
    public static final int JAVA_PLUGIN_OK = 16449537;

    public static void trace(String string) {
        if (tracing) {
            try {
                System.err.println("Child: " + string);
                tracefile.write(string + "\n");
                tracefile.flush();
            }
            catch (IOException iOException) {
                System.err.println("Could not write to trace file");
            }
        }
    }

    public static boolean getTracingFlag() {
        return tracing;
    }

    public static int getNavigVersion() {
        return navig_version;
    }

    public static void error(String string) {
        System.err.println("                      PLUGIN ERROR ");
        System.err.println("                      ************ ");
        System.err.println(string);
        System.err.println("\n");
        Plugin.trace(string);
    }

    public static boolean isOldNavigator() {
        return navig_version < 5;
    }

    public static void start(boolean bl) {
        String string;
        tracing = bl;
        Plugin.loadLibrary();
        String string2 = System.getProperty("javaplugin.nodotversion");
        if (tracing) {
            try {
                tracefile = new FileWriter("/tmp/plugin_java" + string2 + ".trace");
            }
            catch (IOException iOException) {
                Plugin.error("Could not create plugin_java" + string2 + ".trace");
            }
        }
        if ((string = Plugin.getenv("JAVA_PLUGIN_AGENT")).indexOf("Mozilla/3") >= 0) {
            Plugin.trace("Setting Mozilla version to 3");
            navig_version = 3;
        } else if (string.indexOf("Mozilla/4") >= 0) {
            Plugin.trace("Setting Mozilla version to 4");
            navig_version = 4;
        } else {
            Plugin.trace("Setting Mozilla version to 5");
            navig_version = 5;
        }
        Plugin plugin = new Plugin();
        plugin.doit();
    }

    public static int getNPlugins() {
        return panels.size();
    }

    private static String evalString(int n, String string) {
        MotifAppletViewer motifAppletViewer = (MotifAppletViewer)panels.get(new Integer(n));
        return motifAppletViewer.evalString(n, string);
    }

    private void doit() {
        try {
            Object object;
            Object object2;
            Plugin.trace("Plugin class started");
            String string = Plugin.getenv("JAVA_HOME");
            String string2 = Plugin.getenv("HOME");
            this.readProxyInfo();
            JavaRunTime.initEnvironment(string, "", string2);
            String string3 = Plugin.getenv("JAVA_PLUGIN_VERSION");
            if (string3 != null) {
                ((Hashtable)System.getProperties()).put("javaplugin.version", string3);
            }
            if (!tracing) {
                try {
                    object2 = new FileOutputStream("/dev/null");
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object2);
                    object = new PrintStream(bufferedOutputStream);
                    System.setOut((PrintStream)object);
                    System.setErr((PrintStream)object);
                }
                catch (IOException iOException) {
                    Plugin.error("Java process: Couldn't reassign stdout/stderr: " + iOException);
                }
            }
            AppletViewer.initEnvironment(proxyType, proxyInfo, proxyOverrides);
            Plugin.trace("Initialized environment. Printing  messages.\n");
            System.out.print(messages);
            object2 = new Watcher();
            ((Thread)object2).start();
            this.initializeCommunication();
            while (true) {
                int n;
                int n2;
                if (!Plugin.parentAlive()) {
                    Plugin.trace("parent is dead.  Exiting.");
                    System.exit(4);
                }
                int n3 = -1;
                Plugin.trace("Plugin: Reading next  code...");
                try {
                    n3 = cmdIn.readInt();
                }
                catch (IOException iOException) {
                    Plugin.trace("Could not read next command code!");
                }
                if (tracing) {
                    Plugin.trace("VM Received Command >>>" + Plugin.protocol_to_str(n3));
                }
                if (n3 == 16384001) {
                    String string4;
                    alive = true;
                    int n4 = cmdIn.readInt();
                    int n5 = cmdIn.readInt();
                    int n6 = cmdIn.readInt();
                    worker.setEventWindowID(n6);
                    MotifAppletViewer motifAppletViewer = n5 == 0 ? new MotifAppletViewer(n4) : new MotifBeansViewer(n4);
                    n2 = cmdIn.readInt();
                    int n7 = 0;
                    while (n7 < n2) {
                        String string5 = Plugin.readString();
                        string4 = Plugin.readString();
                        if (tracing) {
                            Plugin.trace("    >" + string5 + "=>" + string4);
                        }
                        motifAppletViewer.setParameter(string5, string4);
                        ++n7;
                    }
                    boolean bl = false;
                    try {
                        string4 = motifAppletViewer.getParameter("MAYSCRIPT");
                        bl = Boolean.valueOf(string4);
                        Plugin.trace("Setting mayscript to:" + bl);
                    }
                    catch (Throwable throwable) {
                        Plugin.error("Exception in setting mayscript");
                    }
                    if (bl) {
                        ((MotifAppletContext)motifAppletViewer.getAppletContext()).setMayScript(bl);
                    }
                    panels.put(new Integer(n4), motifAppletViewer);
                    Plugin.trace("Registering panel:" + n4);
                    Plugin.replyOK();
                    continue;
                }
                if (n3 == 16384017) {
                    int n8 = cmdIn.readInt();
                    MotifAppletViewer motifAppletViewer = (MotifAppletViewer)panels.get(new Integer(n8));
                    if (motifAppletViewer == null) continue;
                    motifAppletViewer.sendStartEvent();
                    continue;
                }
                if (n3 == 16384018) {
                    int n9 = cmdIn.readInt();
                    MotifAppletViewer motifAppletViewer = (MotifAppletViewer)panels.get(new Integer(n9));
                    if (motifAppletViewer == null) continue;
                    motifAppletViewer.sendStopEvent();
                    continue;
                }
                if (n3 == 16384002) {
                    int n10 = cmdIn.readInt();
                    MotifAppletViewer motifAppletViewer = (MotifAppletViewer)panels.get(new Integer(n10));
                    if (motifAppletViewer != null) {
                        Plugin.trace("Removing panel:" + n10);
                        panels.remove(new Integer(n10));
                        try {
                            motifAppletViewer.destroy();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    Plugin.replyOK();
                    continue;
                }
                if (n3 == 16384003) {
                    int n11 = cmdIn.readInt();
                    int n12 = cmdIn.readInt();
                    int n13 = cmdIn.readInt();
                    n = cmdIn.readInt();
                    n2 = cmdIn.readInt();
                    int n14 = cmdIn.readInt();
                    MotifAppletViewer motifAppletViewer = (MotifAppletViewer)panels.get(new Integer(n11));
                    Plugin.trace("Window " + n12 + " " + n13 + "x" + n + " " + n2 + "x" + n14);
                    boolean bl = false;
                    if (motifAppletViewer != null) {
                        motifAppletViewer.setWindow(n12, n13, n, n2, n14);
                    }
                    Plugin.replyOK();
                    continue;
                }
                if (n3 == 16384004) {
                    alive = false;
                    continue;
                }
                if (n3 == 16384005) {
                    int n15 = cmdIn.readInt();
                    String string6 = Plugin.readString();
                    Plugin.trace("DOCBASE := " + string6);
                    MotifAppletViewer motifAppletViewer = (MotifAppletViewer)panels.get(new Integer(n15));
                    Plugin.trace("Setting docbase for " + n15 + " to " + string6);
                    if (motifAppletViewer == null) continue;
                    motifAppletViewer.setDocumentBase(new URL(string6));
                    continue;
                }
                if (n3 == 16384006) {
                    Worker.proxmapReady();
                    continue;
                }
                if (n3 == 16384007) {
                    object = Plugin.readString();
                    String string7 = Plugin.readString();
                    Plugin.trace("Plugin.java: PROXY MAPPING: \"" + (String)object + "\" => \"" + string7 + "\"");
                    Worker.addProxyMapping((String)object, string7);
                    continue;
                }
                if (n3 == 16384022) {
                    int n16 = cmdIn.readInt();
                    int n17 = cmdIn.readInt() / 10;
                    int n18 = cmdIn.readInt() / 10;
                    n = cmdIn.readInt() / 10;
                    n2 = cmdIn.readInt() / 10;
                    Plugin.trace("PRINT " + n16 + " x=" + n17 + " y=" + n18 + " w=" + n + " h=" + n2);
                    MotifAppletViewer motifAppletViewer = (MotifAppletViewer)panels.get(new Integer(n16));
                    if (motifAppletViewer != null) {
                        motifAppletViewer.doPrint(n17, n18, n, n2, printOut);
                    }
                    Plugin.replyOK();
                    continue;
                }
                if (n3 == 16384008) {
                    int n19 = cmdIn.readInt();
                    String string8 = Plugin.readString();
                    MotifAppletViewer motifAppletViewer = (MotifAppletViewer)panels.get(new Integer(n19));
                    Worker.setCookieString(string8);
                    continue;
                }
                if (n3 == 16384009) {
                    object = Plugin.readString();
                    Plugin.trace("Reading cached file:" + (String)object);
                    Worker.setCacheFile((String)object);
                    continue;
                }
                if (n3 == 16384023) {
                    object = Plugin.readByteArray();
                    Worker.setHttpsReply((byte[])object);
                    continue;
                }
                if (n3 == 16384024) {
                    object = Plugin.readByteArray();
                    Worker.setHttpsPostReply((byte[])object);
                    continue;
                }
                if (n3 == 0xFA000A) {
                    int n20 = cmdIn.readInt();
                    String string9 = Plugin.readString();
                    MotifAppletViewer motifAppletViewer = (MotifAppletViewer)panels.get(new Integer(n20));
                    if (motifAppletViewer == null) continue;
                    motifAppletViewer.setJSReply(string9);
                    continue;
                }
                if (n3 == 16384011) {
                    int n21 = cmdIn.readInt();
                    MotifAppletViewer motifAppletViewer = (MotifAppletViewer)panels.get(new Integer(n21));
                    if (motifAppletViewer == null) continue;
                    motifAppletViewer.finishJSReply();
                    continue;
                }
                if (n3 == 16384020) {
                    Worker.terminateRequestAbruptly();
                    continue;
                }
                if (n3 == 16384019) {
                    Plugin.trace("Attach Thread ");
                    Plugin.attachThread();
                    continue;
                }
                if (n3 == 16384021) {
                    Plugin.trace("Getting java object");
                    int n22 = cmdIn.readInt();
                    int n23 = OJIPlugin.globalRefToJavaObjectForInstance(n22);
                    cmdOut.writeInt(n23);
                    cmdOut.flush();
                    continue;
                }
                if (n3 == 16384025) {
                    Plugin.trace("Showing Java Console");
                    JavaRunTime.showJavaConsole(true);
                    continue;
                }
                if (n3 == 16384026) {
                    Plugin.trace("Hiding Java Console");
                    JavaRunTime.showJavaConsole(false);
                    continue;
                }
                if (n3 == 16384027) {
                    Plugin.trace("Printing Java Console <not implemented>");
                    continue;
                }
                Plugin.error("Java process: unexpected request " + Integer.toHexString(n3));
                System.exit(6);
            }
        }
        catch (Throwable throwable) {
            if (Plugin.parentAlive()) {
                Plugin.error("Java process caught exception: " + throwable);
                throwable.printStackTrace();
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream("plugin_stack.trace");
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                Plugin.trace("Java process caught exception: " + throwable.toString());
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                printWriter.close();
            }
            catch (IOException iOException) {
                Plugin.error("Could not print the stack trace\n");
            }
            Plugin.trace("Exiting. Navigator may also be dead.");
            System.exit(6);
            return;
        }
    }

    void initializeCommunication() {
        Plugin.trace("Opening pipes at this end\n");
        cmdIn = Plugin.newInput("Command Input", 11);
        cmdOut = Plugin.newOutput("Command Output", 11);
        DataInputStream dataInputStream = Plugin.newInput("Work Input", 12);
        DataOutputStream dataOutputStream = Plugin.newOutput("Work Output", 12);
        FileDescriptor fileDescriptor = Plugin.getPipe(13);
        FileOutputStream fileOutputStream = new FileOutputStream(fileDescriptor);
        printOut = new PrintStream(fileOutputStream);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Plugin.trace("Toolkit = " + toolkit.getClass().getName());
        worker = new Worker(dataInputStream, dataOutputStream);
        Plugin.trace("Initialized worker");
        try {
            cmdOut.write(17);
            cmdOut.flush();
            Plugin.trace("Wrote initial ack on command pipe");
        }
        catch (IOException iOException) {
            Plugin.error("Error in writing back to the parent");
        }
        Plugin.trace("Wrote the initial ack\n");
        int n = -1;
        try {
            n = cmdIn.readInt();
        }
        catch (IOException iOException) {
            Plugin.trace("Child could not read window id!");
        }
        Plugin.trace("Read the event window id:" + n);
        worker.setEventWindowID(n);
        Plugin.trace("Set window ID");
    }

    public static MotifAppletViewer getViewer(int n) {
        Integer n2 = new Integer(n);
        MotifAppletViewer motifAppletViewer = (MotifAppletViewer)panels.get(n2);
        if (motifAppletViewer == null) {
            Plugin.error("Could not find a Viewer for " + n);
        } else {
            Plugin.trace("Found a viewer for:" + n);
        }
        return motifAppletViewer;
    }

    static DataInputStream newInput(String string, int n) {
        Plugin.trace("Creating input pipe:" + string + " fd = " + n);
        FileDescriptor fileDescriptor = Plugin.getPipe(n);
        FileInputStream fileInputStream = new FileInputStream(fileDescriptor);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        return dataInputStream;
    }

    static DataOutputStream newOutput(String string, int n) {
        Plugin.trace("Creating output pipe:" + string + " fd = " + n);
        FileDescriptor fileDescriptor = Plugin.getPipe(n);
        FileOutputStream fileOutputStream = new FileOutputStream(fileDescriptor);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        return dataOutputStream;
    }

    private static String readString() throws IOException {
        int n = cmdIn.readShort();
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = (char)cmdIn.readByte();
            ++n2;
        }
        String string = new String(cArray);
        Plugin.trace("readString:" + string);
        return string;
    }

    private static byte[] readByteArray() throws IOException {
        int n = cmdIn.readInt();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = cmdIn.readByte();
            ++n2;
        }
        return byArray;
    }

    private static void replyOK() throws IOException {
        Plugin.trace("Sending OK reply");
        cmdOut.writeInt(16449537);
        cmdOut.flush();
    }

    private static void loadLibrary() {
        String string = System.getProperty("javaplugin.lib");
        try {
            System.load(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Plugin could not load:" + string);
            System.err.println("Path is:" + System.getProperty("java.library.path"));
            System.err.println(unsatisfiedLinkError.toString());
        }
    }

    void readProxyInfo() {
        String string;
        proxyType = 0;
        proxyInfo = "";
        proxyOverrides = "";
        String string2 = null;
        String string3 = Plugin.getenv("JAVA_PLUGIN_AGENT");
        try {
            String string4;
            int n;
            String[] stringArray;
            String string5;
            String string6;
            BufferedReader bufferedReader;
            FileInputStream fileInputStream;
            Hashtable<String, String> hashtable;
            if (navig_version == 3) {
                string = Plugin.getenv("HOME");
                hashtable = new Hashtable<String, String>();
                fileInputStream = new FileInputStream(string + "/.netscape/preferences");
                bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                while ((string6 = bufferedReader.readLine()) != null) {
                    int n2 = string6.indexOf(58);
                    if (n2 < 0) continue;
                    String string7 = string6.substring(0, n2);
                    string5 = string6.substring(n2 + 1);
                    string7 = string7.trim();
                    if ((string5 = string5.trim()).length() <= 0) continue;
                    hashtable.put(string7, string5);
                }
                string6 = (String)hashtable.get("PROXY_MODE");
                if (string6 == null || string6.equals("0")) {
                    return;
                }
                if (string6.equals("2")) {
                    messages = messages + Plugin.getMessage("no_autoconfig_on_ns3") + "\n";
                    return;
                }
                proxyType = 1;
                stringArray = new String[]{"HTTP", "FTP", "GOPHER", "HTTPS", "WAIS"};
                n = 0;
                while (n < stringArray.length) {
                    string5 = stringArray[n];
                    string4 = (String)hashtable.get(string5 + "_PROXY");
                    if (string4 != null) {
                        if (proxyInfo.length() > 0) {
                            proxyInfo = proxyInfo + ";";
                        }
                        proxyInfo = proxyInfo + string5.toLowerCase(Locale.ENGLISH) + "=" + string4;
                    }
                    ++n;
                }
                string5 = (String)hashtable.get("SOCKS_HOST");
                if (string5 != null) {
                    if (proxyInfo != null) {
                        proxyInfo = proxyInfo + ";";
                    }
                    proxyInfo = proxyInfo + string5;
                }
                string2 = (String)hashtable.get("NO_PROXY");
            } else if (navig_version == 4) {
                string = Plugin.getenv("HOME");
                hashtable = new Hashtable();
                fileInputStream = new FileInputStream(string + "/.netscape/preferences.js");
                bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                while ((string6 = bufferedReader.readLine()) != null) {
                    if (string6.indexOf("user_pref(\"") < 0) continue;
                    string6 = string6.substring(string6.indexOf(34) + 1);
                    int n3 = string6.indexOf(34);
                    String string8 = string6.substring(0, n3);
                    string6 = string6.substring(n3 + 2);
                    if ((string6 = string6.trim()).charAt(0) == '\"') {
                        n3 = string6.indexOf(34, 1);
                        string5 = string6.substring(1, n3);
                    } else {
                        n3 = string6.indexOf(41);
                        string5 = string6.substring(0, n3);
                    }
                    hashtable.put(string8, string5);
                }
                string6 = (String)hashtable.get("network.proxy.type");
                if (string6 == null || string6.equals("0")) {
                    return;
                }
                if (string6.equals("2")) {
                    proxyType = 2;
                    return;
                }
                proxyType = 1;
                stringArray = new String[]{"http", "ftp", "gopher", "https", "wais"};
                n = 0;
                while (n < stringArray.length) {
                    string5 = stringArray[n];
                    string4 = (String)hashtable.get("network.proxy." + string5);
                    if (string4 != null) {
                        if (proxyInfo.length() > 0) {
                            proxyInfo = proxyInfo + ";";
                        }
                        proxyInfo = proxyInfo + string5.toLowerCase() + "=" + string4;
                        String string9 = (String)hashtable.get("network.proxy." + string5 + "_port");
                        if (string9 != null) {
                            proxyInfo = proxyInfo + ":" + string9;
                        }
                    }
                    ++n;
                }
                string5 = (String)hashtable.get("network.hosts.socks_server");
                if (string5 != null) {
                    if (proxyInfo.length() > 0) {
                        proxyInfo = proxyInfo + ";";
                    }
                    proxyInfo = proxyInfo + "socks=" + string5;
                    string4 = (String)hashtable.get("network.hosts.socks_serverport");
                    if (string4 != null) {
                        proxyInfo = proxyInfo + ":" + string4;
                    }
                }
                string2 = (String)hashtable.get("network.proxy.no_proxies_on");
            } else if (navig_version == 5) {
                proxyType = 3;
                return;
            }
        }
        catch (Exception exception) {
            messages = messages + Plugin.getMessage("bad_read_ns_props") + exception + "\n";
        }
        while (string2 != null) {
            int n = string2.indexOf(44);
            if (n < 0) {
                string = string2;
                string2 = null;
            } else {
                string = string2.substring(0, n);
                string2 = string2.substring(n + 1);
            }
            string = string.trim();
            if (string.length() == 0) continue;
            if (proxyOverrides.length() > 0) {
                proxyOverrides = proxyOverrides + ",";
            }
            proxyOverrides = proxyOverrides + "*" + string;
        }
    }

    static boolean isPluginAlive() {
        return alive;
    }

    static String getMessage(String string) {
        try {
            return rb.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    static boolean getTracing() {
        return tracing;
    }

    static native FileDescriptor getPipe(int var0);

    static native boolean parentAlive();

    private static native String getenv(String var0);

    private static native void attachThread();

    public static String protocol_to_str(int n) {
        switch (n) {
            case 16384001: {
                return "JAVA_PLUGIN_NEW";
            }
            case 16384002: {
                return "JAVA_PLUGIN_DESTROY";
            }
            case 16384003: {
                return "JAVA_PLUGIN_WINDOW";
            }
            case 16384004: {
                return "JAVA_PLUGIN_SHUTDOWN";
            }
            case 16384005: {
                return "JAVA_PLUGIN_DOCBASE";
            }
            case 16384006: {
                return "JAVA_PLUGIN_PROXMAP_READY";
            }
            case 16384007: {
                return "JAVA_PLUGIN_PROXY_MAPPING";
            }
            case 16384008: {
                return "JAVA_PLUGIN_COOKIE     ";
            }
            case 16384009: {
                return "JAVA_PLUGIN_CACHED_FILE";
            }
            case 0xFA000A: {
                return "JAVA_PLUGIN_JAVASCRIPT_REPLY";
            }
            case 16384011: {
                return "JAVA_PLUGIN_JAVASCRIPT_END";
            }
            case 16384017: {
                return "JAVA_PLUGIN_START";
            }
            case 16384018: {
                return "JAVA_PLUGIN_STOP";
            }
            case 16384019: {
                return "JAVA_PLUGIN_ATTACH_THRE";
            }
            case 16449537: {
                return "JAVA_PLUGIN_OK";
            }
            case 16384022: {
                return "JAVA_PLUGIN_PRINT";
            }
            case 16384023: {
                return "JAVA_PLUGIN_HTTPS_GET_REPLY";
            }
            case 16384024: {
                return "JAVA_PLUGIN_HTTPS_POST_REPLY";
            }
            case 16384020: {
                return "JAVA_PLUGIN_REQUEST_ABRUPTLY_TERMINATED";
            }
            case 16384025: {
                return "JAVA_PLUGIN_CONSOLE_SHOW";
            }
            case 16384026: {
                return "JAVA_PLUGIN_CONSOLE_HIDE";
            }
            case 16384027: {
                return "JAVA_PLUGIN_CONSOLE_PRINT";
            }
        }
        return "Unknown code:" + n;
    }

    static {
        rb = ResourceBundle.getBundle("sun.plugin.resources.Motif");
        messages = "";
    }

    private class Watcher
    extends Thread {
        private Watcher() {
        }

        public void run() {
            Plugin.trace(" Starting watcher\n");
            while (true) {
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (Plugin.parentAlive()) continue;
                Plugin.trace(" exiting due to parent death");
                System.exit(2);
            }
        }
    }
}

