/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.protocol.jdk12.http;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import sun.plugin.CacheHandler;
import sun.plugin.protocol.CookieHandler;
import sun.plugin.protocol.PluginProxyHandler;
import sun.plugin.protocol.ProxyInfo;
import sun.plugin.protocol.jdk12.http.Handler;
import sun.plugin.protocol.jdk12.http.HttpClient;
import sun.plugin.protocol.jdk12.http.HttpUtils;
import sun.plugin.usability.Trace;
import sun.security.action.GetPropertyAction;

public class HttpURLConnection
extends sun.net.www.protocol.http.HttpURLConnection {
    protected String proxy = null;
    protected int proxyPort = -1;
    boolean failedOnce = false;
    static CookieHandler handler = null;
    private boolean connectStep1 = false;
    private boolean connectStep2 = false;
    private boolean checkSetCookie = false;
    private InputStream cacheStream = null;
    private static ResourceBundle rb;

    public HttpURLConnection(URL uRL, Handler handler) throws IOException {
        super(uRL, handler);
    }

    public HttpURLConnection(URL uRL, String string, int n) throws IOException {
        super(uRL, string, n);
        this.proxy = string;
        this.proxyPort = n;
    }

    public static void setCookieHandler(CookieHandler cookieHandler) {
        handler = cookieHandler;
    }

    protected boolean fromClassLoader() {
        Exception exception = new Exception();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        String string = byteArrayOutputStream.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.startsWith("sun.applet.AppletClassLoader") && !string2.startsWith("sun.applet.AppletResourceLoader") && !string2.startsWith("sun.plugin.security.PluginClassLoader")) continue;
            return true;
        }
        return false;
    }

    protected boolean rightExt() {
        String string = this.url.getFile();
        return string.endsWith(".jar") | string.endsWith(".zip") | string.endsWith(".class") | string.endsWith(".gif") | string.endsWith(".jpg") | string.endsWith(".au") | string.endsWith(".wav");
    }

    void createConnection() throws IOException {
        this.http = "http".equals(this.url.getProtocol()) && !this.failedOnce ? HttpClient.New(this.url, this.proxy, this.proxyPort) : this.getProxiedClient(this.url, this.proxy, this.proxyPort);
        this.ps = (PrintStream)this.http.getOutputStream();
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.connectStep1();
        this.connectStep2();
        if (this.useCaches) {
            try {
                this.cacheStream = (InputStream)AccessController.doPrivileged(new FileCreator(this));
                if (this.cacheStream == null) {
                    this.useCaches = false;
                } else {
                    this.responseCode = 200;
                    HttpURLConnection httpURLConnection = (HttpURLConnection)this.url.openConnection();
                    httpURLConnection.setUseCaches(false);
                    httpURLConnection = HttpUtils.followRedirects(httpURLConnection);
                    this.url = httpURLConnection.url;
                    httpURLConnection.disconnect();
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                Trace.netPrintException(privilegedActionException);
                Trace.netPrintln("IO Exception, using remote copy", 2);
                this.useCaches = false;
            }
            catch (SecurityException securityException) {
                Trace.netPrintException(securityException);
                Trace.netPrintln("Security exception, using remote copy", 2);
                throw securityException;
            }
        }
        if (!this.useCaches) {
            // empty if block
        }
        this.createConnection();
        this.connected = true;
    }

    public synchronized void connectStep1() throws IOException {
        String string;
        if (this.connectStep1) {
            return;
        }
        String string2 = HttpURLConnection.getMessage("opening_url") + this.url;
        Trace.netPrintln(string2, 3);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.url.getHost(), this.url.getPort());
        }
        if ((string = AccessController.doPrivileged(new GetPropertyAction("mozilla.workaround"))) != null && string.equalsIgnoreCase("true")) {
            this.setUseCaches(false);
        } else {
            this.setUseCaches(this.getUseCaches() && this.rightExt() && "GET".equals(this.method));
        }
        this.connectStep1 = true;
    }

    public synchronized void connectStep2() throws IOException {
        Object object;
        Object object2;
        if (this.connectStep2) {
            return;
        }
        if (this.proxy == null) {
            object2 = null;
            object = PluginProxyHandler.getDefaultProxyHandler();
            if (object != null && (object2 = object.getProxyInfo(this.url)) != null) {
                this.proxy = ((ProxyInfo)object2).getProxy();
                this.proxyPort = ((ProxyInfo)object2).getPort();
            }
        }
        object2 = "Connecting " + this.url + " with ";
        if (this.proxy == null) {
            object2 = (String)object2 + HttpURLConnection.getMessage("no_proxy");
        } else {
            object2 = (String)object2 + HttpURLConnection.getMessage("proxy_equals") + this.proxy;
            if (this.proxyPort != -1) {
                object2 = (String)object2 + ":" + this.proxyPort;
            }
        }
        Trace.netPrintln((String)object2);
        if (handler != null && this.getRequestProperty("cookie") == null && (object = handler.getCookieInfo(this.url)) != null) {
            this.setRequestProperty("cookie", (String)object);
        }
        this.connectStep2 = true;
    }

    public synchronized void checkCookieHeader() {
        String string;
        if (this.checkSetCookie) {
            return;
        }
        this.checkSetCookie = true;
        if (handler != null && (string = this.getHeaderField("Set-Cookie")) != null) {
            handler.setCookieInfo(this.url, string);
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        this.connect();
        if (this.cacheStream != null) {
            return this.cacheStream;
        }
        this.checkCookieHeader();
        if (this.responseCode == 404) {
            throw new FileNotFoundException("File not found: " + this.url);
        }
        if (this.responseCode >= 400) {
            throw new IOException("Connection failure with " + this.responseCode);
        }
        return super.getInputStream();
    }

    protected sun.net.www.http.HttpClient getNewClient(URL uRL) throws IOException {
        this.failedOnce = true;
        return this.getProxiedClient(uRL, this.proxy, this.proxyPort);
    }

    protected sun.net.www.http.HttpClient getProxiedClient(URL uRL, String string, int n) throws IOException {
        return new HttpClient(uRL, string, n);
    }

    public static String getMessage(String string) {
        try {
            if (rb == null) {
                rb = ResourceBundle.getBundle("sun.plugin.resources.Activator");
            }
            return rb.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    class FileCreator
    implements PrivilegedExceptionAction {
        HttpURLConnection conn;

        FileCreator(HttpURLConnection httpURLConnection2) {
            this.conn = httpURLConnection2;
        }

        public Object run() throws Exception {
            String string = CacheHandler.getCacheFile(this.conn.getURL());
            if (string != null) {
                return new FileInputStream(string);
            }
            return null;
        }
    }
}

