/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sun.misc.HexDumpEncoder;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.DialogFactory;
import sun.plugin.usability.Trace;
import sun.security.x509.SerialNumber;

public class CertificateDialog
implements ListSelectionListener,
ActionListener {
    private Certificate[] certs = null;
    private int index = 0;
    JTextArea textArea = new JTextArea();

    public CertificateDialog(Certificate[] certificateArray, int n) {
        this.certs = certificateArray;
        this.index = n;
    }

    public void DoModal() {
        if (this.certs.length > this.index && this.certs[this.index] instanceof X509Certificate) {
            Border border = BorderFactory.createEtchedBorder();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, CertificateDialog.getMessage("cert_dialog.field"));
            TitledBorder titledBorder2 = BorderFactory.createTitledBorder(border, CertificateDialog.getMessage("cert_dialog.value"));
            Object[] objectArray = new Object[]{CertificateDialog.getMessage("cert_dialog.field.Version"), CertificateDialog.getMessage("cert_dialog.field.SerialNumber"), CertificateDialog.getMessage("cert_dialog.field.SignatureAlg"), CertificateDialog.getMessage("cert_dialog.field.Issuer"), CertificateDialog.getMessage("cert_dialog.field.Validity"), CertificateDialog.getMessage("cert_dialog.field.Subject"), CertificateDialog.getMessage("cert_dialog.field.Signature")};
            JList<Object> jList = new JList<Object>(objectArray);
            jList.setSelectionMode(0);
            jList.addListSelectionListener(this);
            jList.setSelectedIndex(6);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(titledBorder);
            jPanel.add((Component)new JScrollPane(jList), "Center");
            this.textArea.setLineWrap(false);
            this.textArea.setEditable(false);
            this.textArea.setColumns(40);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.setBorder(titledBorder2);
            jPanel2.add((Component)new JScrollPane(this.textArea), "Center");
            Object[] objectArray2 = new Object[]{jPanel, jPanel2};
            JButton jButton = new JButton(CertificateDialog.getMessage("cert_dialog.viewIssuerButton"));
            jButton.setMnemonic(86);
            if (this.certs.length == this.index + 1) {
                jButton.setEnabled(false);
            } else {
                jButton.addActionListener(this);
            }
            Object[] objectArray3 = new Object[]{CertificateDialog.getMessage("cert_dialog.okButton"), jButton};
            if (!Trace.isAutomationEnabled()) {
                DialogFactory.showOptionDialog(objectArray2, CertificateDialog.getMessage("cert_dialog.title"), objectArray3, objectArray3[0]);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CertificateDialog certificateDialog = new CertificateDialog(this.certs, this.index + 1);
        certificateDialog.DoModal();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = (JList)listSelectionEvent.getSource();
        int n = jList.getSelectedIndex();
        X509Certificate x509Certificate = (X509Certificate)this.certs[this.index];
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 0: {
                stringBuffer.append("V");
                stringBuffer.append(x509Certificate.getVersion());
                break;
            }
            case 1: {
                SerialNumber serialNumber = new SerialNumber(x509Certificate.getSerialNumber());
                stringBuffer.append("[");
                stringBuffer.append(serialNumber.getNumber().toString());
                stringBuffer.append("]");
                break;
            }
            case 2: {
                stringBuffer.append("[");
                stringBuffer.append(x509Certificate.getSigAlgName());
                stringBuffer.append("]");
                break;
            }
            case 3: {
                stringBuffer.append(this.formatDNString(x509Certificate.getIssuerDN().toString()));
                break;
            }
            case 4: {
                stringBuffer.append("[From: ");
                stringBuffer.append(x509Certificate.getNotBefore());
                stringBuffer.append(",\n To: ");
                stringBuffer.append(x509Certificate.getNotAfter());
                stringBuffer.append("]");
                break;
            }
            case 5: {
                stringBuffer.append(this.formatDNString(x509Certificate.getSubjectDN().toString()));
                break;
            }
            case 6: {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                stringBuffer.append(hexDumpEncoder.encodeBuffer(x509Certificate.getSignature()));
                break;
            }
        }
        this.textArea.setText(stringBuffer.toString());
        this.textArea.repaint();
    }

    private String formatDNString(String string) {
        int n = string.length();
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\"' || c == '\'') {
                boolean bl3 = bl2 = !bl2;
            }
            if (c == ',' && !bl2) {
                stringBuffer.append(",\n");
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static String getMessage(String string) {
        return ResourceHandler.getMessage(string);
    }
}

