/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.IOException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.CertificateStore;
import sun.plugin.security.PluginCertificateStore;
import sun.plugin.security.RootCACertificateStore;
import sun.plugin.security.SessionCertificateStore;
import sun.plugin.security.TrustDeciderDialog;
import sun.plugin.usability.Trace;
import sun.security.action.GetPropertyAction;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.NetscapeCertTypeExtension;

public class TrustDecider {
    private static CertificateStore rootStore = new RootCACertificateStore();
    private static CertificateStore permanentStore = new PluginCertificateStore();
    private static CertificateStore sessionStore = new SessionCertificateStore();
    private static final String OID_BASIC_CONSTRAINTS = "2.5.29.19";
    private static final String OID_KEY_USAGE = "2.5.29.15";
    private static final String OID_EXTENDED_KEY_USAGE = "2.5.29.37";
    private static final String OID_NETSCAPE_CERT_TYPE = "2.16.840.1.113730.1.1";
    private static final String OID_EKU_ANY_USAGE = "2.5.29.37.0";
    private static final String OID_EKU_CODE_SIGNING = "1.3.6.1.5.5.7.3.3";
    private static final String NSCT_OBJECT_SIGNING_CA = "object_signing_ca";
    private static final String NSCT_OBJECT_SIGNING = "object_signing";
    private static final String NSCT_SSL_CA = "ssl_ca";
    private static final String NSCT_S_MIME_CA = "s_mime_ca";

    public static void reset() {
        rootStore = new RootCACertificateStore();
        permanentStore = new PluginCertificateStore();
        sessionStore = new SessionCertificateStore();
    }

    public static boolean isAllPermissionGranted(CodeSource codeSource) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        String string = null;
        Certificate[] certificateArray = codeSource.getCertificates();
        String string2 = codeSource.getLocation().toString();
        if (certificateArray == null) {
            if (TrustDecider.isBrowserMozilla()) {
                return TrustDecider.isAllPermissionGranted(codeSource, string2, null, null, 0, null, 0, "");
            }
            return false;
        }
        rootStore.load();
        permanentStore.load();
        sessionStore.load();
        int n = 0;
        int n2 = 0;
        while (n2 < certificateArray.length) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int n3 = n;
            CertificateExpiredException certificateExpiredException = null;
            CertificateNotYetValidException certificateNotYetValidException = null;
            n3 = n;
            while (n3 < certificateArray.length) {
                block40: {
                    object4 = null;
                    object3 = null;
                    if (certificateArray[n3] instanceof X509Certificate) {
                        object4 = (X509Certificate)certificateArray[n3];
                    }
                    object3 = n3 + 1 < certificateArray.length && certificateArray[n3 + 1] instanceof X509Certificate ? (Object)((X509Certificate)certificateArray[n3 + 1]) : object4;
                    try {
                        object4.checkValidity();
                    }
                    catch (CertificateExpiredException certificateExpiredException2) {
                        if (certificateExpiredException == null) {
                            certificateExpiredException = certificateExpiredException2;
                        }
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException2) {
                        if (certificateNotYetValidException != null) break block40;
                        certificateNotYetValidException = certificateNotYetValidException2;
                    }
                }
                if (!rootStore.contains((Certificate)object4) && n3 + 1 != certificateArray.length && TrustDecider.isIssuerOf((X509Certificate)object4, (X509Certificate)object3)) {
                    Set set = object4.getCriticalExtensionOIDs();
                    if (set == null) {
                        set = Collections.EMPTY_SET;
                    }
                    if (!TrustDecider.checkBasicConstraints((X509Certificate)object4, set, n3 - n)) {
                        Trace.securityPrintln("trustdecider.check.basicconstraints");
                        string = ResourceHandler.getMessage("trustdecider.check.basicconstraints");
                        throw new CertificateException(string);
                    }
                    if (n3 == n) {
                        if (!TrustDecider.checkLeafKeyUsage((X509Certificate)object4, set)) {
                            Trace.securityPrintln("trustdecider.check.leafkeyusage");
                            string = ResourceHandler.getMessage("trustdecider.check.leafkeyusage");
                            throw new CertificateException(string);
                        }
                    } else if (!TrustDecider.checkSignerKeyUsage((X509Certificate)object4, set)) {
                        Trace.securityPrintln("trustdecider.check.signerkeyusage");
                        string = ResourceHandler.getMessage("trustdecider.check.signerkeyusage");
                        throw new CertificateException(string);
                    }
                    if (!set.isEmpty()) {
                        Trace.securityPrintln("trustdecider.check.extensions");
                        string = ResourceHandler.getMessage("trustdecider.check.extensions");
                        throw new CertificateException(string);
                    }
                }
                if (!TrustDecider.isIssuerOf((X509Certificate)object4, (X509Certificate)object3)) break;
                try {
                    object4.verify(((Certificate)object3).getPublicKey());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    Trace.securityPrintln("trustdecider.check.signature");
                    string = ResourceHandler.getMessage("trustdecider.check.signature");
                    throw new CertificateException(string);
                }
                ++n3;
            }
            int n4 = n2 = n3 < certificateArray.length ? n3 + 1 : n3;
            if (TrustDecider.isBrowserMozilla()) {
                object4 = TrustDecider.makeChain(certificateArray, n, n2);
                if (object4 != null) {
                    object3 = new int[((byte[][])object4).length];
                    int n5 = 0;
                    while (n5 < ((Object)object4).length) {
                        object3[n5] = (byte[])((Object)object4[n5]).length;
                        ++n5;
                    }
                    X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
                    byte[] byArray = x509Certificate.getSignature();
                    if (TrustDecider.isAllPermissionGranted(codeSource, string2, object4, (int[])object3, ((Object)object4).length, byArray, byArray.length, (String)(object2 = (object = (Object)x509Certificate.getSubjectDN()).getName()))) {
                        return true;
                    }
                }
            } else {
                int n6;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                if (!rootStore.verify(certificateArray[n2 - 1])) {
                    Trace.securityPrintln("JRE CA Root Verify failed, use IE Win32 APIs", 2);
                    object = TrustDecider.makeChain(certificateArray, n, n2);
                    if (object != null) {
                        object2 = new int[((byte[][])object).length];
                        int n7 = 0;
                        while (n7 < ((Object)object).length) {
                            object2[n7] = ((Object)object[n7]).length;
                            ++n7;
                        }
                        X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
                        byte[] byArray = x509Certificate.getSignature();
                        Principal principal = x509Certificate.getSubjectDN();
                        String string3 = principal.getName();
                        try {
                            String string4 = AccessController.doPrivileged(new GetPropertyAction("os.name"));
                            if (string4.indexOf("Windows") != -1) {
                                bl4 = true;
                            }
                        }
                        catch (Exception exception) {
                            Trace.printException(exception);
                        }
                        if (bl4) {
                            bl5 = TrustDecider.isRootVerifiedByIE(codeSource, string2, (byte[][])object, (int[])object2, ((Object)object).length, byArray, byArray.length, string3);
                        }
                        if (!bl5) {
                            bl2 = true;
                        }
                    } else {
                        throw new CertificateException("Unable to verify the certificate with root CA");
                    }
                }
                if (permanentStore.contains(certificateArray[n])) {
                    return true;
                }
                if (sessionStore.contains(certificateArray[n])) {
                    return true;
                }
                if (certificateExpiredException != null || certificateNotYetValidException != null) {
                    bl3 = true;
                }
                if ((n6 = TrustDecider.showSecurityDialog(codeSource, bl2, bl3)) == 0) {
                    Trace.securityPrintln(ResourceHandler.getMessage("trustdecider.user.grant.session"), 2);
                    sessionStore.add(certificateArray[n]);
                    sessionStore.save();
                    bl = true;
                } else if (n6 == 2) {
                    Trace.securityPrintln(ResourceHandler.getMessage("trustdecider.user.grant.forever"), 2);
                    permanentStore.add(certificateArray[n]);
                    permanentStore.save();
                    bl = true;
                } else {
                    Trace.securityPrintln(ResourceHandler.getMessage("trustdecider.user.deny"), 2);
                    bl = false;
                }
                return bl;
            }
            n = n2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkBasicConstraints(X509Certificate x509Certificate, Set set, int n) throws CertificateException, IOException {
        set.remove(OID_BASIC_CONSTRAINTS);
        set.remove(OID_NETSCAPE_CERT_TYPE);
        if (n == 0) {
            return true;
        }
        if (x509Certificate.getExtensionValue(OID_BASIC_CONSTRAINTS) == null) {
            if (x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null) {
                if (TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) return true;
                Trace.securityPrintln("trustdecider.check.basicconstraints.certtypebit");
                return false;
            }
            Trace.securityPrintln("trustdecider.check.basicconstraints.extensionvalue");
            return false;
        }
        if (x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null && (TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_SSL_CA) || TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_S_MIME_CA) || TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) && !TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING_CA)) {
            Trace.securityPrintln("trustdecider.check.basicconstraints.bitvalue");
            return false;
        }
        int n2 = x509Certificate.getBasicConstraints();
        if (n2 < 0) {
            Trace.securityPrintln("trustdecider.check.basicconstraints.enduser");
            return false;
        }
        if (n - 1 <= n2) return true;
        Trace.securityPrintln("trustdecider.check.basicconstraints.pathlength");
        return false;
    }

    private static boolean checkLeafKeyUsage(X509Certificate x509Certificate, Set set) throws CertificateException, IOException {
        List list;
        set.remove(OID_KEY_USAGE);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null) {
            if (blArray.length == 0) {
                Trace.securityPrintln("trustdecider.check.leafkeyusage.length");
                return false;
            }
            boolean bl = blArray[0];
            if (!bl) {
                Trace.securityPrintln("trustdecider.check.leafkeyusage.digitalsignature");
                return false;
            }
        }
        if ((list = TrustDecider.getExtendedKeyUsage(x509Certificate)) != null && set.contains(OID_EXTENDED_KEY_USAGE)) {
            set.remove(OID_EXTENDED_KEY_USAGE);
            if (!list.contains(OID_EKU_ANY_USAGE) && !list.contains(OID_EKU_CODE_SIGNING)) {
                Trace.securityPrintln("trustdecider.check.leafkeyusage.extkeyusageinfo");
                return false;
            }
        }
        if (x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE) != null && !TrustDecider.getNetscapeCertTypeBit(x509Certificate, NSCT_OBJECT_SIGNING)) {
            Trace.securityPrintln("trustdecider.check.leafkeyusage.certtypebit");
            return false;
        }
        return true;
    }

    private static boolean checkSignerKeyUsage(X509Certificate x509Certificate, Set set) throws CertificateException, IOException {
        set.remove(OID_KEY_USAGE);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (!(blArray == null || blArray.length >= 6 && blArray[5])) {
            Trace.securityPrintln("trustdecider.check.signerkeyusage.lengthandbit");
            return false;
        }
        List list = TrustDecider.getExtendedKeyUsage(x509Certificate);
        if (list != null && set.contains(OID_EXTENDED_KEY_USAGE)) {
            set.remove(OID_EXTENDED_KEY_USAGE);
            if (!list.contains(OID_EKU_ANY_USAGE)) {
                Trace.securityPrintln("trustdecider.check.signerkeyusage.keyusage");
                return false;
            }
        }
        return true;
    }

    private static boolean getNetscapeCertTypeBit(X509Certificate x509Certificate, String string) throws CertificateException, IOException {
        byte[] byArray = x509Certificate.getExtensionValue(OID_NETSCAPE_CERT_TYPE);
        if (byArray == null) {
            return false;
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        byte[] byArray2 = derInputStream.getOctetString();
        byArray2 = new DerValue(byArray2).getUnalignedBitString().toByteArray();
        NetscapeCertTypeExtension netscapeCertTypeExtension = new NetscapeCertTypeExtension(byArray2);
        Boolean bl = (Boolean)netscapeCertTypeExtension.get(string);
        return bl;
    }

    private static List getExtendedKeyUsage(X509Certificate x509Certificate) throws CertificateException, IOException {
        Object object;
        byte[] byArray = x509Certificate.getExtensionValue(OID_EXTENDED_KEY_USAGE);
        if (byArray == null) {
            return null;
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        byte[] byArray2 = derInputStream.getOctetString();
        DerValue derValue = new DerValue(byArray2);
        Vector<ObjectIdentifier> vector = new Vector<ObjectIdentifier>(1, 1);
        while (derValue.data.available() != 0) {
            object = derValue.data.getDerValue();
            ObjectIdentifier objectIdentifier = ((DerValue)object).getOID();
            vector.addElement(objectIdentifier);
        }
        object = new ArrayList(vector.size());
        int n = 0;
        while (n < vector.size()) {
            ((ArrayList)object).add(vector.elementAt(n).toString());
            ++n;
        }
        return object;
    }

    private static native boolean isBrowserMozilla();

    private static native boolean isAllPermissionGranted(CodeSource var0, String var1, byte[][] var2, int[] var3, int var4, byte[] var5, int var6, String var7);

    private static native boolean isRootVerifiedByIE(CodeSource var0, String var1, byte[][] var2, int[] var3, int var4, byte[] var5, int var6, String var7);

    private static byte[][] makeChain(Certificate[] certificateArray, int n, int n2) throws CertificateEncodingException {
        if (n == n2) {
            return null;
        }
        byte[][] byArrayArray = new byte[n2 - n][];
        int n3 = n;
        while (n3 < n2) {
            byArrayArray[n3 - n] = certificateArray[n3].getEncoded();
            ++n3;
        }
        return byArrayArray;
    }

    private static boolean isIssuerOf(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Principal principal;
        Principal principal2 = x509Certificate.getIssuerDN();
        return principal2.equals(principal = x509Certificate2.getSubjectDN());
    }

    static int showSecurityDialog(CodeSource codeSource, boolean bl, boolean bl2) {
        Integer n = (Integer)AccessController.doPrivileged(new PrivilegedBlockAction(codeSource, bl, bl2));
        int n2 = 1;
        if (n != null) {
            n2 = n;
        }
        return n2;
    }

    private static class PrivilegedBlockAction
    implements PrivilegedAction {
        Certificate[] certs;
        boolean rootCANotValid = false;
        boolean timeNotValid = false;

        PrivilegedBlockAction(CodeSource codeSource, boolean bl, boolean bl2) {
            this.certs = codeSource.getCertificates();
            this.rootCANotValid = bl;
            this.timeNotValid = bl2;
        }

        public Object run() {
            TrustDeciderDialog trustDeciderDialog = new TrustDeciderDialog(this.certs, this.rootCANotValid, this.timeNotValid);
            return new Integer(trustDeciderDialog.DoModal());
        }
    }
}

