/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.iiop;

import com.sun.corba.se.internal.core.ClientGIOP;
import com.sun.corba.se.internal.core.EndPoint;
import com.sun.corba.se.internal.core.IOR;
import com.sun.corba.se.internal.core.Profile;
import com.sun.corba.se.internal.core.RequestHandler;
import com.sun.corba.se.internal.core.ServerGIOP;
import com.sun.corba.se.internal.iiop.Connection;
import com.sun.corba.se.internal.iiop.ConnectionTable;
import com.sun.corba.se.internal.iiop.EndPointImpl;
import com.sun.corba.se.internal.iiop.ListenerThread;
import com.sun.corba.se.internal.iiop.ORB;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class GIOPImpl
implements ClientGIOP,
ServerGIOP {
    private int requestId = 5;
    protected ConnectionTable table;
    protected ORB orb;
    private RequestHandler handler;
    protected int listenerPort;
    protected Vector endPoints = new Vector();
    protected ListenerThread listenerThread;
    private EndPoint bootstrapEndpoint;

    protected synchronized int getNextRequestId() {
        return this.requestId++;
    }

    public GIOPImpl(ORB oRB, RequestHandler requestHandler) {
        this.orb = oRB;
        this.table = new ConnectionTable(oRB, this);
        this.setRequestHandler(requestHandler);
    }

    public Connection getConnection(EndPoint endPoint) {
        return this.table.get(endPoint);
    }

    public void deleteConnection(EndPoint endPoint) {
        try {
            this.table.deleteConn(endPoint);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int allocateRequestId() {
        return this.getNextRequestId();
    }

    public void setRequestHandler(RequestHandler requestHandler) {
        this.handler = requestHandler;
    }

    public RequestHandler getRequestHandler() {
        return this.handler;
    }

    public IOR locate(IOR iOR) {
        Profile profile = iOR.getProfile();
        byte[] byArray = profile.getObjectKey();
        Connection connection = this.table.get(iOR.getEndpoint());
        IOR iOR2 = connection.locate(this.getNextRequestId(), byArray);
        if (iOR2 == null) {
            iOR2 = iOR;
        }
        return iOR2;
    }

    public synchronized void initEndpoints() {
        if (this.endPoints.size() == 0) {
            this.getEndpoint(123, 0, null);
        }
    }

    public synchronized EndPoint getDefaultEndpoint() {
        if (this.endPoints.size() == 0) {
            return null;
        }
        return (EndPoint)this.endPoints.elementAt(0);
    }

    public synchronized EndPoint getEndpoint(int n, int n2, InetAddress inetAddress) {
        Object object;
        String string = null;
        if (inetAddress != null) {
            string = inetAddress.getHostName().toLowerCase();
        }
        Enumeration enumeration = this.endPoints.elements();
        while (enumeration.hasMoreElements()) {
            object = (EndPoint)enumeration.nextElement();
            if (object.getType() != n || object.getPort() != n2 || !object.getHostName().equals(string)) continue;
            return object;
        }
        if (n2 == 0 && this.orb.getORBServerPort() != 0) {
            n2 = this.orb.getORBServerPort();
        }
        this.listenerThread = this.createListener(n2);
        object = this.listenerThread.getSocket();
        this.listenerPort = ((ServerSocket)object).getLocalPort();
        EndPointImpl endPointImpl = new EndPointImpl(n, this.listenerPort, this.orb.getORBServerHost());
        this.endPoints.addElement(endPointImpl);
        return endPointImpl;
    }

    public synchronized EndPoint getBootstrapEndpoint(int n) {
        if (this.bootstrapEndpoint == null) {
            this.bootstrapEndpoint = this.getEndpoint(123, n, null);
        }
        return this.bootstrapEndpoint;
    }

    private synchronized ListenerThread createListener(int n) {
        ListenerThread listenerThread;
        final ConnectionTable connectionTable = this.table;
        try {
            final ServerSocket serverSocket = this.orb.getSocketFactory().createServerSocket(n);
            listenerThread = (ListenerThread)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ListenerThread listenerThread = new ListenerThread(connectionTable, serverSocket);
                    listenerThread.setDaemon(true);
                    return listenerThread;
                }
            });
            listenerThread.start();
        }
        catch (Exception exception) {
            throw new INTERNAL(1398079496, CompletionStatus.COMPLETED_NO);
        }
        return listenerThread;
    }

    void destroyConnections() {
        if (this.listenerThread != null) {
            this.listenerThread.shutdown();
        }
        this.table.destroyConnections();
    }
}

