/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.ref.WeakReference;

public class ThreadLocal {
    private final int threadLocalHashCode = ThreadLocal.nextHashCode();
    private static int nextHashCode = 0;
    private static final int HASH_INCREMENT = 1640531527;

    private static synchronized int nextHashCode() {
        int n = nextHashCode;
        nextHashCode = n + 1640531527;
        return n;
    }

    protected Object initialValue() {
        return null;
    }

    public Object get() {
        Thread thread = Thread.currentThread();
        ThreadLocalMap threadLocalMap = this.getMap(thread);
        if (threadLocalMap != null) {
            return threadLocalMap.get(this);
        }
        Object object = this.initialValue();
        this.createMap(thread, object);
        return object;
    }

    public void set(Object object) {
        Thread thread = Thread.currentThread();
        ThreadLocalMap threadLocalMap = this.getMap(thread);
        if (threadLocalMap != null) {
            threadLocalMap.set(this, object);
        } else {
            this.createMap(thread, object);
        }
    }

    ThreadLocalMap getMap(Thread thread) {
        return thread.threadLocals;
    }

    void createMap(Thread thread, Object object) {
        thread.threadLocals = new ThreadLocalMap(this, object);
    }

    static ThreadLocalMap createInheritedMap(ThreadLocalMap threadLocalMap) {
        return new ThreadLocalMap(threadLocalMap);
    }

    Object childValue(Object object) {
        throw new UnsupportedOperationException();
    }

    static class ThreadLocalMap {
        private static final int INITIAL_CAPACITY = 16;
        private Entry[] table;
        private int size = 0;
        private int threshold;

        private void setThreshold(int n) {
            this.threshold = n * 2 / 3;
        }

        private static int nextIndex(int n, int n2) {
            return n + 1 < n2 ? n + 1 : 0;
        }

        private static int prevIndex(int n, int n2) {
            return n - 1 >= 0 ? n - 1 : n2 - 1;
        }

        ThreadLocalMap(ThreadLocal threadLocal, Object object) {
            this.table = new Entry[16];
            int n = threadLocal.threadLocalHashCode & 0xF;
            this.table[n] = new Entry(threadLocal, object);
            this.size = 1;
            this.setThreshold(16);
        }

        private ThreadLocalMap(ThreadLocalMap threadLocalMap) {
            Entry[] entryArray = threadLocalMap.table;
            int n = entryArray.length;
            this.setThreshold(n);
            this.table = new Entry[n];
            int n2 = 0;
            while (n2 < n) {
                Object object;
                Entry entry = entryArray[n2];
                if (entry != null && (object = entry.get()) != null) {
                    ThreadLocal threadLocal = (ThreadLocal)object;
                    Object object2 = threadLocal.childValue(entry.value);
                    Entry entry2 = new Entry(threadLocal, object2);
                    int n3 = threadLocal.threadLocalHashCode & n - 1;
                    while (this.table[n3] != null) {
                        n3 = ThreadLocalMap.nextIndex(n3, n);
                    }
                    this.table[n3] = entry2;
                    ++this.size;
                }
                ++n2;
            }
        }

        private Object get(ThreadLocal threadLocal) {
            int n = threadLocal.threadLocalHashCode & this.table.length - 1;
            Entry entry = this.table[n];
            if (entry != null && entry.get() == threadLocal) {
                return entry.value;
            }
            return this.getAfterMiss(threadLocal, n, entry);
        }

        private Object getAfterMiss(ThreadLocal threadLocal, int n, Entry entry) {
            Object object;
            Entry[] entryArray = this.table;
            int n2 = entryArray.length;
            while (entry != null) {
                object = entry.get();
                if (object == threadLocal) {
                    return entry.value;
                }
                if (object == null) {
                    return this.replaceStaleEntry(threadLocal, null, n, true);
                }
                n = ThreadLocalMap.nextIndex(n, n2);
                entry = entryArray[n];
            }
            object = threadLocal.initialValue();
            entryArray[n] = new Entry(threadLocal, object);
            if (++this.size >= this.threshold) {
                this.rehash();
            }
            return object;
        }

        private void set(ThreadLocal threadLocal, Object object) {
            Entry[] entryArray = this.table;
            int n = entryArray.length;
            int n2 = threadLocal.threadLocalHashCode & n - 1;
            Entry entry = entryArray[n2];
            while (entry != null) {
                Object object2 = entry.get();
                if (object2 == threadLocal) {
                    entry.value = object;
                    return;
                }
                if (object2 == null) {
                    this.replaceStaleEntry(threadLocal, object, n2, false);
                    return;
                }
                n2 = ThreadLocalMap.nextIndex(n2, n);
                entry = entryArray[n2];
            }
            entryArray[n2] = new Entry(threadLocal, object);
            if (++this.size >= this.threshold) {
                this.rehash();
            }
        }

        private Object replaceStaleEntry(ThreadLocal threadLocal, Object object, int n, boolean bl) {
            Entry entry;
            Entry[] entryArray = this.table;
            int n2 = entryArray.length;
            int n3 = n;
            int n4 = ThreadLocalMap.prevIndex(n, n2);
            while ((entry = entryArray[n4]) != null) {
                if (entry.get() == null) {
                    n3 = n4;
                }
                n4 = ThreadLocalMap.prevIndex(n4, n2);
            }
            int n5 = ThreadLocalMap.nextIndex(n, n2);
            while ((entry = entryArray[n5]) != null) {
                Object object2 = entry.get();
                if (object2 == threadLocal) {
                    if (bl) {
                        object = entry.value;
                    } else {
                        entry.value = object;
                    }
                    entryArray[n5] = entryArray[n];
                    entryArray[n] = entry;
                    if (n3 == n) {
                        n3 = n5;
                    }
                    this.expungeStaleEntry(n3);
                    return object;
                }
                if (object2 == null && n3 == n) {
                    n3 = n5;
                }
                n5 = ThreadLocalMap.nextIndex(n5, n2);
            }
            if (bl) {
                object = threadLocal.initialValue();
            }
            entryArray[n].value = null;
            entryArray[n] = new Entry(threadLocal, object);
            if (n3 != n) {
                this.expungeStaleEntry(n3);
            }
            return object;
        }

        private void expungeStaleEntry(int n) {
            Entry entry;
            Entry[] entryArray = this.table;
            int n2 = entryArray.length;
            entryArray[n].value = null;
            entryArray[n] = null;
            --this.size;
            int n3 = ThreadLocalMap.nextIndex(n, n2);
            while ((entry = entryArray[n3]) != null) {
                Object object = entry.get();
                if (object == null) {
                    entry.value = null;
                    entryArray[n3] = null;
                    --this.size;
                } else {
                    ThreadLocal threadLocal = (ThreadLocal)object;
                    int n4 = threadLocal.threadLocalHashCode & n2 - 1;
                    if (n4 != n3) {
                        entryArray[n3] = null;
                        while (entryArray[n4] != null) {
                            n4 = ThreadLocalMap.nextIndex(n4, n2);
                        }
                        entryArray[n4] = entry;
                    }
                }
                n3 = ThreadLocalMap.nextIndex(n3, n2);
            }
        }

        private void rehash() {
            this.expungeStaleEntries();
            if (this.size >= this.threshold - this.threshold / 4) {
                this.resize();
            }
        }

        private void resize() {
            Entry[] entryArray = this.table;
            int n = entryArray.length;
            int n2 = n * 2;
            Entry[] entryArray2 = new Entry[n2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                Entry entry = entryArray[n4];
                entryArray[n4] = null;
                if (entry != null) {
                    Object object = entry.get();
                    if (object == null) {
                        entry.value = null;
                    } else {
                        ThreadLocal threadLocal = (ThreadLocal)object;
                        int n5 = threadLocal.threadLocalHashCode & n2 - 1;
                        while (entryArray2[n5] != null) {
                            n5 = ThreadLocalMap.nextIndex(n5, n2);
                        }
                        entryArray2[n5] = entry;
                        ++n3;
                    }
                }
                ++n4;
            }
            this.setThreshold(n2);
            this.size = n3;
            this.table = entryArray2;
        }

        private void expungeStaleEntries() {
            Entry[] entryArray = this.table;
            int n = entryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Entry entry = entryArray[n2];
                if (entry != null && entry.get() == null) {
                    this.expungeStaleEntry(n2);
                }
                ++n2;
            }
        }

        private static class Entry
        extends WeakReference {
            private Object value;

            private Entry(ThreadLocal threadLocal, Object object) {
                super(threadLocal);
                this.value = object;
            }
        }
    }
}

