/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;

class TableView
extends BoxView
implements ViewFactory {
    private AttributeSet attr;
    private StyleSheet.BoxPainter painter;
    private int cellSpacing;
    private int captionIndex = -1;
    private boolean relativeCells;
    private boolean multiRowCells;
    int[] columnSpans;
    int[] columnOffsets;
    SizeRequirements[] columnRequirements;
    RowIterator rowIterator = new RowIterator();
    ColumnIterator colIterator = new ColumnIterator();
    Vector rows = new Vector();
    boolean gridValid = false;
    private static final BitSet EMPTY = new BitSet();

    public TableView(Element element) {
        super(element, 1);
    }

    protected RowView createTableRow(Element element) {
        Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object == HTML.Tag.TR) {
            return new RowView(element);
        }
        return null;
    }

    public int getColumnCount() {
        return this.columnSpans.length;
    }

    public int getColumnSpan(int n) {
        if (n < this.columnSpans.length) {
            return this.columnSpans[n];
        }
        return 0;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getMultiRowSpan(int n, int n2) {
        RowView rowView = this.getRow(n);
        RowView rowView2 = this.getRow(n2);
        if (rowView != null && rowView2 != null) {
            int n3 = rowView.viewIndex;
            int n4 = rowView2.viewIndex;
            int n5 = this.getOffset(1, n4) - this.getOffset(1, n3) + this.getSpan(1, n4);
            return n5;
        }
        return 0;
    }

    public int getRowSpan(int n) {
        RowView rowView = this.getRow(n);
        if (rowView != null) {
            return this.getSpan(1, rowView.viewIndex);
        }
        return 0;
    }

    RowView getRow(int n) {
        if (n < this.rows.size()) {
            return (RowView)this.rows.elementAt(n);
        }
        return null;
    }

    protected int getColumnsOccupied(View view) {
        AttributeSet attributeSet = view.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.COLSPAN);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    protected int getRowsOccupied(View view) {
        AttributeSet attributeSet = view.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.ROWSPAN);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    protected void invalidateGrid() {
        this.gridValid = false;
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    void updateInsets() {
        short s = (short)this.painter.getInset(1, this);
        short s2 = (short)this.painter.getInset(3, this);
        if (this.captionIndex != -1) {
            View view = this.getView(this.captionIndex);
            short s3 = (short)view.getPreferredSpan(1);
            AttributeSet attributeSet = view.getAttributes();
            Object object = attributeSet.getAttribute(CSS.Attribute.CAPTION_SIDE);
            if (object != null && object.equals("bottom")) {
                s2 = (short)(s2 + s3);
            } else {
                s = (short)(s + s3);
            }
        }
        this.setInsets(s, (short)this.painter.getInset(2, this), s2, (short)this.painter.getInset(4, this));
    }

    protected void setPropertiesFromAttributes() {
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.painter = styleSheet.getBoxPainter(this.attr);
        if (this.attr != null) {
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
        }
    }

    void updateGrid() {
        if (!this.gridValid) {
            this.relativeCells = false;
            this.multiRowCells = false;
            this.captionIndex = -1;
            this.rows.removeAllElements();
            int n = this.getViewCount();
            int n2 = 0;
            while (n2 < n) {
                Object object;
                View view = this.getView(n2);
                if (view instanceof RowView) {
                    this.rows.addElement(view);
                    object = (RowView)view;
                    ((RowView)object).clearFilledColumns();
                    ((RowView)object).rowIndex = this.rows.size() - 1;
                    ((RowView)object).viewIndex = n2;
                } else {
                    HTML.Tag tag;
                    object = view.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
                    if (object instanceof HTML.Tag && (tag = (HTML.Tag)object) == HTML.Tag.CAPTION) {
                        this.captionIndex = n2;
                    }
                }
                ++n2;
            }
            int n3 = 0;
            int n4 = this.rows.size();
            int n5 = 0;
            while (n5 < n4) {
                RowView rowView = this.getRow(n5);
                int n6 = 0;
                int n7 = 0;
                while (n7 < rowView.getViewCount()) {
                    int n8;
                    AttributeSet attributeSet;
                    CSS.LengthValue lengthValue;
                    View view = rowView.getView(n7);
                    if (!this.relativeCells && (lengthValue = (CSS.LengthValue)(attributeSet = view.getAttributes()).getAttribute(CSS.Attribute.WIDTH)) != null && lengthValue.isPercentage()) {
                        this.relativeCells = true;
                    }
                    while (rowView.isFilled(n6)) {
                        ++n6;
                    }
                    int n9 = this.getRowsOccupied(view);
                    if (n9 > 1) {
                        this.multiRowCells = true;
                    }
                    if ((n8 = this.getColumnsOccupied(view)) > 1 || n9 > 1) {
                        int n10 = n5 + n9;
                        int n11 = n6 + n8;
                        int n12 = n5;
                        while (n12 < n10) {
                            int n13 = n6;
                            while (n13 < n11) {
                                if (n12 != n5 || n13 != n6) {
                                    this.addFill(n12, n13);
                                }
                                ++n13;
                            }
                            ++n12;
                        }
                        if (n8 > 1) {
                            n6 += n8 - 1;
                        }
                    }
                    ++n7;
                    ++n6;
                }
                n3 = Math.max(n3, n6);
                ++n5;
            }
            this.columnSpans = new int[n3];
            this.columnOffsets = new int[n3];
            this.columnRequirements = new SizeRequirements[n3];
            int n14 = 0;
            while (n14 < n3) {
                this.columnRequirements[n14] = new SizeRequirements();
                ++n14;
            }
            this.gridValid = true;
        }
    }

    void addFill(int n, int n2) {
        RowView rowView = this.getRow(n);
        if (rowView != null) {
            rowView.fillColumn(n2);
        }
    }

    protected void layoutColumns(int n, int[] nArray, int[] nArray2, SizeRequirements[] sizeRequirementsArray) {
        this.colIterator.setLayoutArrays(nArray, nArray2, n);
        CSS.calculateTiledLayout(this.colIterator, n);
    }

    void calculateColumnRequirements(int n) {
        int n2;
        int n3;
        int n4;
        boolean bl = false;
        int n5 = this.getRowCount();
        int n6 = 0;
        while (n6 < n5) {
            RowView rowView = this.getRow(n6);
            int n7 = 0;
            n4 = rowView.getViewCount();
            n3 = 0;
            while (n3 < n4) {
                View view = rowView.getView(n3);
                while (rowView.isFilled(n7)) {
                    ++n7;
                }
                int n8 = this.getRowsOccupied(view);
                n2 = this.getColumnsOccupied(view);
                if (n2 == 1) {
                    this.checkSingleColumnCell(n, n7, view);
                } else {
                    bl = true;
                    n7 += n2 - 1;
                }
                ++n3;
                ++n7;
            }
            ++n6;
        }
        if (bl) {
            int n9 = 0;
            while (n9 < n5) {
                RowView rowView = this.getRow(n9);
                n4 = 0;
                n3 = rowView.getViewCount();
                int n10 = 0;
                while (n10 < n3) {
                    View view = rowView.getView(n10);
                    while (rowView.isFilled(n4)) {
                        ++n4;
                    }
                    n2 = this.getColumnsOccupied(view);
                    if (n2 > 1) {
                        this.checkMultiColumnCell(n, n4, n2, view);
                        n4 += n2 - 1;
                    }
                    ++n10;
                    ++n4;
                }
                ++n9;
            }
        }
    }

    void checkSingleColumnCell(int n, int n2, View view) {
        SizeRequirements sizeRequirements = this.columnRequirements[n2];
        sizeRequirements.minimum = Math.max((int)view.getMinimumSpan(n), sizeRequirements.minimum);
        sizeRequirements.preferred = Math.max((int)view.getPreferredSpan(n), sizeRequirements.preferred);
        sizeRequirements.maximum = Math.max((int)view.getMaximumSpan(n), sizeRequirements.maximum);
    }

    void checkMultiColumnCell(int n, int n2, int n3, View view) {
        int n4;
        Object object;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n5 = 0;
        while (n5 < n3) {
            SizeRequirements sizeRequirements = this.columnRequirements[n2 + n5];
            l += (long)sizeRequirements.minimum;
            l2 += (long)sizeRequirements.preferred;
            l3 += (long)sizeRequirements.maximum;
            ++n5;
        }
        int n6 = (int)view.getMinimumSpan(n);
        if ((long)n6 > l) {
            Object object2;
            SizeRequirements[] sizeRequirementsArray = new SizeRequirements[n3];
            int n7 = 0;
            while (n7 < n3) {
                sizeRequirementsArray[n7] = this.columnRequirements[n2 + n7];
                object2 = sizeRequirementsArray[n7];
                object2.maximum = Math.max(object2.maximum, (int)view.getMaximumSpan(n));
                ++n7;
            }
            object2 = new int[n3];
            object = new int[n3];
            SizeRequirements.calculateTiledPositions(n6, null, sizeRequirementsArray, object, object2);
            int n8 = 0;
            while (n8 < n3) {
                SizeRequirements sizeRequirements = sizeRequirementsArray[n8];
                sizeRequirements.minimum = Math.max(object2[n8], sizeRequirements.minimum);
                sizeRequirements.preferred = Math.max(sizeRequirements.minimum, sizeRequirements.preferred);
                sizeRequirements.maximum = Math.max(sizeRequirements.preferred, sizeRequirements.maximum);
                ++n8;
            }
        }
        if ((long)(n4 = (int)view.getPreferredSpan(n)) > l2) {
            SizeRequirements[] sizeRequirementsArray = new SizeRequirements[n3];
            int n9 = 0;
            while (n9 < n3) {
                sizeRequirementsArray[n9] = this.columnRequirements[n2 + n9];
                object = sizeRequirementsArray[n9];
                ++n9;
            }
            object = new int[n3];
            int[] nArray = new int[n3];
            SizeRequirements.calculateTiledPositions(n4, null, sizeRequirementsArray, nArray, object);
            int n10 = 0;
            while (n10 < n3) {
                SizeRequirements sizeRequirements = sizeRequirementsArray[n10];
                sizeRequirements.preferred = Math.max(object[n10], sizeRequirements.preferred);
                sizeRequirements.maximum = Math.max(sizeRequirements.preferred, sizeRequirements.maximum);
                ++n10;
            }
        }
    }

    boolean spanSetFromAttributes(int n, SizeRequirements sizeRequirements) {
        AttributeSet attributeSet = this.getAttributes();
        if (n == 0) {
            CSS.LengthValue lengthValue = (CSS.LengthValue)attributeSet.getAttribute(CSS.Attribute.WIDTH);
            if (lengthValue != null && !lengthValue.isPercentage()) {
                sizeRequirements.preferred = sizeRequirements.maximum = (int)lengthValue.getValue();
                sizeRequirements.minimum = sizeRequirements.maximum;
                return true;
            }
        } else {
            CSS.LengthValue lengthValue = (CSS.LengthValue)attributeSet.getAttribute(CSS.Attribute.HEIGHT);
            if (lengthValue != null && !lengthValue.isPercentage()) {
                sizeRequirements.preferred = sizeRequirements.maximum = (int)lengthValue.getValue();
                sizeRequirements.minimum = sizeRequirements.maximum;
                return true;
            }
        }
        return false;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        String string;
        this.updateGrid();
        this.calculateColumnRequirements(n);
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n2 = this.columnRequirements.length;
        int n3 = 0;
        while (n3 < n2) {
            SizeRequirements sizeRequirements2 = this.columnRequirements[n3];
            l += (long)sizeRequirements2.minimum;
            l2 += (long)sizeRequirements2.preferred;
            l3 += (long)sizeRequirements2.maximum;
            ++n3;
        }
        int n4 = (n2 - 1) * this.cellSpacing;
        sizeRequirements.minimum = (int)(l += (long)n4);
        sizeRequirements.preferred = (int)(l2 += (long)n4);
        sizeRequirements.maximum = (int)l2;
        this.spanSetFromAttributes(n, sizeRequirements);
        Object object = this.attr.getAttribute(CSS.Attribute.TEXT_ALIGN);
        sizeRequirements.alignment = object != null ? ((string = object.toString()).equals("left") ? 0.0f : (string.equals("center") ? 0.5f : (string.equals("right") ? 1.0f : 0.0f))) : 0.0f;
        return sizeRequirements;
    }

    protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        this.updateInsets();
        this.rowIterator.updateAdjustments();
        sizeRequirements = CSS.calculateTiledRequirements(this.rowIterator, sizeRequirements);
        sizeRequirements.maximum = sizeRequirements.preferred;
        return sizeRequirements;
    }

    protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        this.updateGrid();
        int n3 = this.getRowCount();
        int n4 = 0;
        while (n4 < n3) {
            RowView rowView = this.getRow(n4);
            rowView.layoutChanged(n2);
            ++n4;
        }
        this.calculateColumnRequirements(n2);
        this.layoutColumns(n, this.columnOffsets, this.columnSpans, this.columnRequirements);
        super.layoutMinorAxis(n, n2, nArray, nArray2);
    }

    protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        this.rowIterator.setLayoutArrays(nArray, nArray2);
        CSS.calculateTiledLayout(this.rowIterator, n);
        if (this.captionIndex != -1) {
            int n3;
            View view = this.getView(this.captionIndex);
            nArray2[this.captionIndex] = n3 = (int)view.getPreferredSpan(1);
            short s = (short)this.painter.getInset(3, this);
            nArray[this.captionIndex] = s != this.getBottomInset() ? n + s : (int)(-this.getTopInset());
        }
    }

    protected View getViewAtPosition(int n, Rectangle rectangle) {
        View view;
        int n2 = this.getViewCount();
        int n3 = 0;
        while (n3 < n2) {
            view = this.getView(n3);
            int n4 = view.getStartOffset();
            int n5 = view.getEndOffset();
            if (n >= n4 && n < n5) {
                if (rectangle != null) {
                    this.childAllocation(n3, rectangle);
                }
                return view;
            }
            ++n3;
        }
        if (n == this.getEndOffset()) {
            view = this.getView(n2 - 1);
            if (rectangle != null) {
                this.childAllocation(n2 - 1, rectangle);
            }
            return view;
        }
        return null;
    }

    public AttributeSet getAttributes() {
        if (this.attr == null) {
            StyleSheet styleSheet = this.getStyleSheet();
            this.attr = styleSheet.getViewAttributes(this);
        }
        return this.attr;
    }

    public void paint(Graphics graphics, Shape shape) {
        int n;
        int n2;
        Rectangle rectangle = shape.getBounds();
        this.setSize(rectangle.width, rectangle.height);
        if (this.captionIndex != -1) {
            n2 = (int)this.painter.getInset(1, this);
            n = (int)this.painter.getInset(3, this);
            if (n2 != this.getTopInset()) {
                int n3 = this.getTopInset() - n2;
                rectangle.y += n3;
                rectangle.height -= n3;
            } else {
                rectangle.height -= this.getBottomInset() - n;
            }
        }
        this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
        n2 = this.getViewCount();
        n = 0;
        while (n < n2) {
            View view = this.getView(n);
            view.paint(graphics, this.getChildAllocation(n, shape));
            ++n;
        }
    }

    public void setParent(View view) {
        super.setParent(view);
        this.setPropertiesFromAttributes();
    }

    public ViewFactory getViewFactory() {
        return this;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.insertUpdate(documentEvent, shape, this);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.removeUpdate(documentEvent, shape, this);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, this);
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Container container;
        super.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        if (shape != null && (container = this.getContainer()) != null) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void replace(int n, int n2, View[] viewArray) {
        super.replace(n, n2, viewArray);
        this.invalidateGrid();
    }

    public View create(Element element) {
        ViewFactory viewFactory;
        Object object;
        Object object2 = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object2 instanceof HTML.Tag) {
            object = (HTML.Tag)object2;
            if (object == HTML.Tag.TR) {
                return this.createTableRow(element);
            }
            if (object == HTML.Tag.TD || object == HTML.Tag.TH) {
                return new CellView(element);
            }
            if (object == HTML.Tag.CAPTION) {
                return new ParagraphView(element);
            }
        }
        if ((object = this.getParent()) != null && (viewFactory = ((View)object).getViewFactory()) != null) {
            return viewFactory.create(element);
        }
        return null;
    }

    class CellView
    extends BlockView {
        public CellView(Element element) {
            super(element, 1);
        }

        protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            super.layoutMajorAxis(n, n2, nArray, nArray2);
            int n3 = 0;
            int n4 = nArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                n3 += nArray2[n5];
                ++n5;
            }
            int n6 = 0;
            if (n3 < n) {
                String string = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.VALIGN);
                if (string == null) {
                    AttributeSet attributeSet = this.getElement().getParentElement().getAttributes();
                    string = (String)attributeSet.getAttribute(HTML.Attribute.VALIGN);
                }
                if (string == null || string.equals("middle")) {
                    n6 = (n - n3) / 2;
                } else if (string.equals("bottom")) {
                    n6 = n - n3;
                }
            }
            if (n6 != 0) {
                int n7 = 0;
                while (n7 < n4) {
                    int n8 = n7++;
                    nArray[n8] = nArray[n8] + n6;
                }
            }
        }

        protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
            SizeRequirements sizeRequirements2 = super.calculateMajorAxisRequirements(n, sizeRequirements);
            sizeRequirements2.maximum = Integer.MAX_VALUE;
            return sizeRequirements2;
        }
    }

    public class RowView
    extends BoxView {
        private StyleSheet.BoxPainter painter;
        private AttributeSet attr;
        BitSet fillColumns = new BitSet();
        int rowIndex;
        int viewIndex;
        boolean multiRowCells;

        public RowView(Element element) {
            super(element, 0);
            this.setPropertiesFromAttributes();
        }

        void clearFilledColumns() {
            this.fillColumns.and(EMPTY);
        }

        void fillColumn(int n) {
            this.fillColumns.set(n);
        }

        boolean isFilled(int n) {
            return this.fillColumns.get(n);
        }

        int getColumnCount() {
            int n = 0;
            int n2 = this.fillColumns.size();
            int n3 = 0;
            while (n3 < n2) {
                if (this.fillColumns.get(n3)) {
                    ++n;
                }
                ++n3;
            }
            return this.getViewCount() + n;
        }

        public AttributeSet getAttributes() {
            return this.attr;
        }

        protected StyleSheet getStyleSheet() {
            HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
            return hTMLDocument.getStyleSheet();
        }

        public void preferenceChanged(View view, boolean bl, boolean bl2) {
            super.preferenceChanged(view, bl, bl2);
            if (TableView.this.multiRowCells && bl2) {
                int n = this.rowIndex - 1;
                while (n >= 0) {
                    RowView rowView = TableView.this.getRow(n);
                    if (rowView.multiRowCells) {
                        rowView.preferenceChanged(null, false, true);
                        break;
                    }
                    --n;
                }
            }
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            super.changedUpdate(documentEvent, shape, viewFactory);
            int n = documentEvent.getOffset();
            if (n <= this.getStartOffset() && n + documentEvent.getLength() >= this.getEndOffset()) {
                this.setPropertiesFromAttributes();
            }
        }

        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = (Rectangle)shape;
            this.painter.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this);
            super.paint(graphics, rectangle);
        }

        public void replace(int n, int n2, View[] viewArray) {
            super.replace(n, n2, viewArray);
            TableView.this.invalidateGrid();
        }

        protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            this.multiRowCells = false;
            int n2 = this.getViewCount();
            int n3 = 0;
            while (n3 < n2) {
                View view = this.getView(n3);
                if (TableView.this.getRowsOccupied(view) > 1) {
                    this.multiRowCells = true;
                    l3 = Math.max((long)((int)view.getMaximumSpan(n)), l3);
                } else {
                    l = Math.max((long)((int)view.getMinimumSpan(n)), l);
                    l2 = Math.max((long)((int)view.getPreferredSpan(n)), l2);
                    l3 = Math.max((long)((int)view.getMaximumSpan(n)), l3);
                }
                ++n3;
            }
            if (sizeRequirements == null) {
                sizeRequirements = new SizeRequirements();
                sizeRequirements.alignment = 0.5f;
            }
            sizeRequirements.preferred = (int)l2;
            sizeRequirements.minimum = (int)l;
            sizeRequirements.maximum = (int)l3;
            return sizeRequirements;
        }

        protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            int n3 = 0;
            int n4 = this.getViewCount();
            int n5 = TableView.this.columnSpans.length;
            int n6 = 0;
            while (n6 < n4 && n3 < n5) {
                View view = this.getView(n6);
                while (this.isFilled(n3)) {
                    ++n3;
                }
                int n7 = TableView.this.getColumnsOccupied(view);
                nArray2[n6] = TableView.this.columnSpans[n3];
                nArray[n6] = TableView.this.columnOffsets[n3];
                if (n7 > 1) {
                    int n8 = TableView.this.columnSpans.length;
                    int n9 = 1;
                    while (n9 < n7) {
                        if (n3 + n9 < n8) {
                            int n10 = n6;
                            nArray2[n10] = nArray2[n10] + TableView.this.columnSpans[n3 + n9];
                        }
                        ++n9;
                    }
                    n3 += n7 - 1;
                }
                ++n6;
                ++n3;
            }
        }

        protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            super.layoutMinorAxis(n, n2, nArray, nArray2);
            int n3 = 0;
            int n4 = this.getViewCount();
            int n5 = 0;
            while (n5 < n4) {
                View view = this.getView(n5);
                while (this.isFilled(n3)) {
                    ++n3;
                }
                int n6 = TableView.this.getColumnsOccupied(view);
                int n7 = TableView.this.getRowsOccupied(view);
                if (n7 > 1) {
                    int n8 = this.rowIndex;
                    int n9 = Math.min(this.rowIndex + n7 - 1, TableView.this.getRowCount() - 1);
                    nArray2[n5] = TableView.this.getMultiRowSpan(n8, n9);
                }
                if (n6 > 1) {
                    n3 += n6 - 1;
                }
                ++n5;
                ++n3;
            }
        }

        public int getResizeWeight(int n) {
            return 1;
        }

        protected View getViewAtPosition(int n, Rectangle rectangle) {
            View view;
            int n2 = this.getViewCount();
            int n3 = 0;
            while (n3 < n2) {
                view = this.getView(n3);
                int n4 = view.getStartOffset();
                int n5 = view.getEndOffset();
                if (n >= n4 && n < n5) {
                    if (rectangle != null) {
                        this.childAllocation(n3, rectangle);
                    }
                    return view;
                }
                ++n3;
            }
            if (n == this.getEndOffset()) {
                view = this.getView(n2 - 1);
                if (rectangle != null) {
                    this.childAllocation(n2 - 1, rectangle);
                }
                return view;
            }
            return null;
        }

        void setPropertiesFromAttributes() {
            StyleSheet styleSheet = this.getStyleSheet();
            this.attr = styleSheet.getViewAttributes(this);
            this.painter = styleSheet.getBoxPainter(this.attr);
        }
    }

    class RowIterator
    implements CSS.LayoutIterator {
        private int row;
        private int[] adjustments;
        private int[] offsets;
        private int[] spans;

        RowIterator() {
        }

        void updateAdjustments() {
            int n = 1;
            if (TableView.this.multiRowCells) {
                int n2 = TableView.this.getRowCount();
                this.adjustments = new int[n2];
                int n3 = 0;
                while (n3 < n2) {
                    RowView rowView = TableView.this.getRow(n3);
                    if (rowView.multiRowCells) {
                        int n4 = rowView.getViewCount();
                        int n5 = 0;
                        while (n5 < n4) {
                            View view = rowView.getView(n5);
                            int n6 = TableView.this.getRowsOccupied(view);
                            if (n6 > 1) {
                                int n7 = (int)view.getPreferredSpan(n);
                                this.adjustMultiRowSpan(n7, n6, n3);
                            }
                            ++n5;
                        }
                    }
                    ++n3;
                }
            } else {
                this.adjustments = null;
            }
        }

        void adjustMultiRowSpan(int n, int n2, int n3) {
            if (n3 + n2 > this.getCount() && (n2 = this.getCount() - n3) < 1) {
                return;
            }
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                RowView rowView = TableView.this.getRow(n3 + n5);
                n4 = (int)((float)n4 + rowView.getPreferredSpan(1));
                ++n5;
            }
            if (n > n4) {
                int n6 = n - n4;
                int n7 = n6 / n2;
                int n8 = n7 + (n6 - n7 * n2);
                RowView rowView = TableView.this.getRow(n3);
                int n9 = n3;
                this.adjustments[n9] = this.adjustments[n9] + n8;
                int n10 = 1;
                while (n10 < n2) {
                    int n11 = n3 + n10;
                    this.adjustments[n11] = this.adjustments[n11] + n7;
                    ++n10;
                }
            }
        }

        void setLayoutArrays(int[] nArray, int[] nArray2) {
            this.offsets = nArray;
            this.spans = nArray2;
        }

        public void setOffset(int n) {
            RowView rowView = TableView.this.getRow(this.row);
            if (rowView != null) {
                this.offsets[rowView.viewIndex] = n;
            }
        }

        public int getOffset() {
            RowView rowView = TableView.this.getRow(this.row);
            if (rowView != null) {
                return this.offsets[rowView.viewIndex];
            }
            return 0;
        }

        public void setSpan(int n) {
            RowView rowView = TableView.this.getRow(this.row);
            if (rowView != null) {
                this.spans[rowView.viewIndex] = n;
            }
        }

        public int getSpan() {
            RowView rowView = TableView.this.getRow(this.row);
            if (rowView != null) {
                return this.spans[rowView.viewIndex];
            }
            return 0;
        }

        public int getCount() {
            return TableView.this.rows.size();
        }

        public void setIndex(int n) {
            this.row = n;
        }

        public float getMinimumSpan(float f) {
            return this.getPreferredSpan(f);
        }

        public float getPreferredSpan(float f) {
            RowView rowView = TableView.this.getRow(this.row);
            if (rowView != null) {
                int n = this.adjustments != null ? this.adjustments[this.row] : 0;
                return rowView.getPreferredSpan(TableView.this.getAxis()) + (float)(n += 2 * TableView.this.cellSpacing);
            }
            return 0.0f;
        }

        public float getMaximumSpan(float f) {
            return this.getPreferredSpan(f);
        }

        public float getLeadingCollapseSpan() {
            return TableView.this.cellSpacing;
        }

        public float getTrailingCollapseSpan() {
            return TableView.this.cellSpacing;
        }
    }

    class ColumnIterator
    implements CSS.LayoutIterator {
        private int col;
        private int[] percentages;
        private int[] offsets;
        private int[] spans;

        ColumnIterator() {
        }

        void disablePercentages() {
            this.percentages = null;
        }

        private void updatePercentages(int n) {
            if (TableView.this.relativeCells) {
                this.percentages = new int[TableView.this.columnRequirements.length];
                int n2 = TableView.this.getRowCount();
                int n3 = 0;
                while (n3 < n2) {
                    RowView rowView = TableView.this.getRow(n3);
                    int n4 = 0;
                    int n5 = rowView.getViewCount();
                    int n6 = 0;
                    while (n6 < n5) {
                        View view = rowView.getView(n6);
                        while (rowView.isFilled(n4)) {
                            ++n4;
                        }
                        int n7 = TableView.this.getRowsOccupied(view);
                        int n8 = TableView.this.getColumnsOccupied(view);
                        AttributeSet attributeSet = view.getAttributes();
                        CSS.LengthValue lengthValue = (CSS.LengthValue)attributeSet.getAttribute(CSS.Attribute.WIDTH);
                        if (lengthValue != null && lengthValue.isPercentage()) {
                            int n9 = (int)(lengthValue.getValue(n) / (float)n8 + 0.5f);
                            int n10 = 0;
                            while (n10 < n8) {
                                this.percentages[n4 + n10] = Math.max(this.percentages[n4 + n10], n9);
                                ++n10;
                            }
                        }
                        n4 += n8 - 1;
                        ++n6;
                        ++n4;
                    }
                    ++n3;
                }
            } else {
                this.percentages = null;
            }
        }

        public void setLayoutArrays(int[] nArray, int[] nArray2, int n) {
            this.offsets = nArray;
            this.spans = nArray2;
            this.updatePercentages(n);
        }

        public int getCount() {
            return TableView.this.columnRequirements.length;
        }

        public void setIndex(int n) {
            this.col = n;
        }

        public void setOffset(int n) {
            this.offsets[this.col] = n;
        }

        public int getOffset() {
            return this.offsets[this.col];
        }

        public void setSpan(int n) {
            this.spans[this.col] = n;
        }

        public int getSpan() {
            return this.spans[this.col];
        }

        public float getMinimumSpan(float f) {
            if (this.percentages != null && this.percentages[this.col] != 0) {
                return Math.max(this.percentages[this.col], TableView.this.columnRequirements[this.col].minimum);
            }
            return TableView.this.columnRequirements[this.col].minimum;
        }

        public float getPreferredSpan(float f) {
            if (this.percentages != null && this.percentages[this.col] != 0) {
                return Math.max(this.percentages[this.col], TableView.this.columnRequirements[this.col].preferred);
            }
            return TableView.this.columnRequirements[this.col].preferred;
        }

        public float getMaximumSpan(float f) {
            if (this.percentages != null && this.percentages[this.col] != 0) {
                return Math.max(this.percentages[this.col], TableView.this.columnRequirements[this.col].preferred);
            }
            return TableView.this.columnRequirements[this.col].maximum;
        }

        public float getLeadingCollapseSpan() {
            return TableView.this.cellSpacing;
        }

        public float getTrailingCollapseSpan() {
            return TableView.this.cellSpacing;
        }
    }
}

