/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.ListIterator;

public class RepaintArea
extends Rectangle {
    private LinkedList rectangleList;

    public RepaintArea() {
        this.rectangleList = new LinkedList();
    }

    private RepaintArea(RepaintArea repaintArea) {
        super(repaintArea);
        this.rectangleList = (LinkedList)repaintArea.rectangleList.clone();
    }

    public synchronized void add(Rectangle rectangle) {
        if (rectangle.isEmpty()) {
            return;
        }
        if (this.contains(rectangle)) {
            return;
        }
        this.rectangleList.add(rectangle);
        if (this.isEmpty()) {
            this.setBounds(rectangle);
        } else {
            super.add(rectangle);
        }
    }

    public boolean contains(int n, int n2) {
        if (super.contains(n, n2)) {
            ListIterator listIterator = this.rectangleList.listIterator(0);
            while (listIterator.hasNext()) {
                if (!((Rectangle)listIterator.next()).contains(n, n2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n, int n2, int n3, int n4) {
        if (super.contains(n, n2, n3, n4)) {
            ListIterator listIterator = this.rectangleList.listIterator(0);
            while (listIterator.hasNext()) {
                if (!((Rectangle)listIterator.next()).contains(n, n2, n3, n4)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(Rectangle rectangle) {
        return this.contains(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean intersects(int n, int n2, int n3, int n4) {
        if (super.intersects(n, n2, n3, n4)) {
            ListIterator listIterator = this.rectangleList.listIterator(0);
            while (listIterator.hasNext()) {
                if (!((Rectangle)listIterator.next()).intersects(n, n2, n3, n4)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean intersects(Rectangle rectangle) {
        return this.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Object clone() {
        return new RepaintArea(this);
    }

    private synchronized RepaintArea cloneAndReset() {
        RepaintArea repaintArea = (RepaintArea)this.clone();
        this.rectangleList.clear();
        this.setBounds(0, 0, 0, 0);
        return repaintArea;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(Object object, boolean bl) {
        Graphics graphics;
        block9: {
            block8: {
                graphics = ((Component)object).getGraphics();
                if (graphics == null) {
                    return;
                }
                try {
                    Rectangle rectangle;
                    Rectangle rectangle2;
                    RepaintArea repaintArea = this.cloneAndReset();
                    int n = repaintArea.rectangleList.size();
                    if (n == 0) {
                        Object var9_6 = null;
                        graphics.dispose();
                        return;
                    }
                    if (n == 2 && !(rectangle2 = (Rectangle)repaintArea.rectangleList.removeFirst()).intersects(rectangle = (Rectangle)repaintArea.rectangleList.removeFirst())) {
                        graphics.setClip(rectangle2);
                        if (bl) {
                            graphics.clearRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        }
                        ((Component)object).paint(graphics);
                        graphics.setClip(rectangle);
                        if (bl) {
                            graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                        ((Component)object).paint(graphics);
                        break block8;
                    }
                    graphics.setClip(repaintArea);
                    if (bl) {
                        graphics.clearRect(repaintArea.x, repaintArea.y, repaintArea.width, repaintArea.height);
                    }
                    ((Component)object).paint(graphics);
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    graphics.dispose();
                    throw throwable;
                }
            }
            Object var9_7 = null;
            graphics.dispose();
            return;
        }
        Object var9_8 = null;
        graphics.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(Object object) {
        Graphics graphics;
        block6: {
            block5: {
                graphics = ((Component)object).getGraphics();
                if (graphics == null) {
                    return;
                }
                try {
                    Rectangle rectangle;
                    Rectangle rectangle2;
                    RepaintArea repaintArea = this.cloneAndReset();
                    int n = repaintArea.rectangleList.size();
                    if (n == 0) {
                        Object var8_5 = null;
                        graphics.dispose();
                        return;
                    }
                    if (n == 2 && !(rectangle2 = (Rectangle)repaintArea.rectangleList.removeFirst()).intersects(rectangle = (Rectangle)repaintArea.rectangleList.removeFirst())) {
                        graphics.setClip(rectangle2);
                        ((Component)object).update(graphics);
                        graphics.setClip(rectangle);
                        ((Component)object).update(graphics);
                        break block5;
                    }
                    graphics.setClip(repaintArea);
                    ((Component)object).update(graphics);
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    graphics.dispose();
                    throw throwable;
                }
            }
            Object var8_6 = null;
            graphics.dispose();
            return;
        }
        Object var8_7 = null;
        graphics.dispose();
    }
}

