/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.StringTokenizer;
import sun.misc.REException;
import sun.misc.RegexpPool;
import sun.net.NetworkClient;
import sun.net.ProgressData;
import sun.net.ProgressEntry;
import sun.net.www.HeaderParser;
import sun.net.www.MessageHeader;
import sun.net.www.MeteredStream;
import sun.net.www.http.ChunkedInputStream;
import sun.net.www.http.KeepAliveCache;
import sun.net.www.http.KeepAliveStream;
import sun.net.www.http.PosterOutputStream;
import sun.security.action.GetPropertyAction;

public class HttpClient
extends NetworkClient {
    MessageHeader requests;
    PosterOutputStream poster = null;
    boolean failedOnce = false;
    KeepAliveStream kas;
    private static RegexpPool dontProxy = new RegexpPool();
    private static String dontProxySource = null;
    private static final int HTTP_CONTINUE = 100;
    static final int httpPortNumber = 80;
    public static String proxyHost = null;
    public static int proxyPort = 80;
    private String instProxy = null;
    private int instProxyPort = -1;
    protected boolean proxyDisabled;
    public boolean usingProxy = false;
    private String host;
    private int port;
    protected static KeepAliveCache kac = new KeepAliveCache();
    boolean keepingAlive = false;
    int keepAliveConnections = -1;
    int keepAliveTimeout = 0;
    protected URL url;

    protected int getDefaultPort() {
        return 80;
    }

    public static synchronized void resetProperties() {
    }

    int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    private String getProxyHost() {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("http.proxyHost"));
        if (string == null) {
            string = (String)AccessController.doPrivileged(new GetPropertyAction("proxyHost"));
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private int getProxyPort() {
        final int[] nArray = new int[]{0};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                nArray[0] = System.getProperty("http.proxyHost") != null ? Integer.getInteger("http.proxyPort", 80).intValue() : Integer.getInteger("proxyPort", 80).intValue();
                return null;
            }
        });
        return nArray[0];
    }

    public boolean getHttpKeepAliveSet() {
        boolean bl = true;
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("http.keepAlive");
            }
        });
        if (string != null) {
            bl = Boolean.valueOf(string);
        }
        return bl;
    }

    private static RegexpPool getDontProxy() {
        RegexpPool regexpPool = dontProxy;
        synchronized (regexpPool) {
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("http.nonProxyHosts"));
            if (string == dontProxySource) {
                RegexpPool regexpPool2 = dontProxy;
                return regexpPool2;
            }
            RegexpPool regexpPool3 = new RegexpPool();
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
                try {
                    while (stringTokenizer.hasMoreTokens()) {
                        regexpPool3.add(stringTokenizer.nextToken().toLowerCase(), Boolean.TRUE);
                    }
                }
                catch (REException rEException) {
                    System.err.println("Error in http.nonProxyHosts system property:  " + rEException);
                }
            }
            dontProxySource = string;
            dontProxy = regexpPool3;
        }
        return dontProxy;
    }

    public HttpClient(URL uRL, String string, int n) throws IOException {
        this(uRL, string, n, false);
    }

    private HttpClient(URL uRL, String string, int n, boolean bl) throws IOException {
        this.proxyDisabled = bl;
        if (!bl) {
            this.instProxy = string;
            this.instProxyPort = n < 0 ? this.getDefaultPort() : n;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(uRL.getHost());
            this.host = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            this.host = uRL.getHost();
        }
        this.url = uRL;
        this.port = uRL.getPort();
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.openServer();
    }

    protected HttpClient(URL uRL, boolean bl) throws IOException {
        this(uRL, null, -1, bl);
    }

    private HttpClient(URL uRL) throws IOException {
        this(uRL, null, -1, false);
    }

    public static HttpClient New(URL uRL) throws IOException {
        HttpClient httpClient = (HttpClient)kac.get(uRL);
        if (httpClient == null) {
            httpClient = new HttpClient(uRL);
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
            httpClient.url = uRL;
        }
        return httpClient;
    }

    public static void finished(HttpClient httpClient) {
        --httpClient.keepAliveConnections;
        if (httpClient.keepAliveConnections > 0 && httpClient.keepingAlive && !httpClient.serverOutput.checkError()) {
            kac.put(httpClient.url, httpClient);
        } else {
            httpClient.closeServer();
        }
    }

    public void openServer(String string, int n) throws IOException {
        this.serverSocket = this.doConnect(string, n);
        this.serverOutput = new PrintStream(new BufferedOutputStream(this.serverSocket.getOutputStream()));
        this.serverSocket.setTcpNoDelay(true);
    }

    private synchronized void privilegedOpenServer(final String string, final int n) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    HttpClient.this.openServer(string, n);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void superOpenServer(String string, int n) throws IOException, UnknownHostException {
        super.openServer(string, n);
    }

    private synchronized void privilegedSuperOpenServer(final String string, final int n) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    HttpClient.this.superOpenServer(string, n);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private boolean isLoopback(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.equalsIgnoreCase("localhost")) {
            return true;
        }
        if (!Character.isDigit(string.charAt(0))) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            if (c < '0' || c > '9') {
                return false;
            }
            int n3 = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return false;
                }
                n3 = n3 * 10 + c - 48;
                if (++n2 >= cArray.length) break;
                c = cArray[n2];
            }
            if (n3 > 255) {
                return false;
            }
            if (bl) {
                bl = false;
                if (n3 != 127) {
                    return false;
                }
            }
            ++n;
            ++n2;
        }
        return n == 4 && !string.endsWith(".");
    }

    private synchronized void openServer() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.host, this.port);
        }
        if (this.keepingAlive) {
            return;
        }
        RegexpPool regexpPool = HttpClient.getDontProxy();
        String string = this.url.getHost().toLowerCase();
        boolean bl = this.isLoopback(string);
        if (this.url.getProtocol().equals("http")) {
            if (this.instProxy != null && !bl) {
                this.privilegedOpenServer(this.instProxy, this.instProxyPort);
                this.usingProxy = true;
                return;
            }
            String string2 = this.getProxyHost();
            if (string2 != null && !this.proxyDisabled && !bl && regexpPool.match(string) == null && regexpPool.match(this.host) == null) {
                try {
                    int n = this.getProxyPort();
                    this.privilegedOpenServer(string2, n);
                    this.instProxy = string2;
                    this.instProxyPort = n;
                    this.usingProxy = true;
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.openServer(this.host, this.port);
            this.usingProxy = false;
            return;
        }
        if (this.instProxy != null && !bl) {
            this.privilegedSuperOpenServer(this.instProxy, this.instProxyPort);
            this.usingProxy = true;
            return;
        }
        String string3 = this.getProxyHost();
        if (string3 != null && !this.proxyDisabled && !bl && regexpPool.match(string) == null && regexpPool.match(this.host) == null) {
            try {
                int n = this.getProxyPort();
                this.privilegedSuperOpenServer(string3, n);
                this.instProxy = string3;
                this.instProxyPort = n;
                this.usingProxy = true;
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.openServer(this.host, this.port);
        this.usingProxy = false;
    }

    public String getURLFile() throws IOException {
        String string = this.url.getFile();
        if (string == null || string.length() == 0) {
            string = "/";
        }
        if (this.usingProxy) {
            String string2 = this.url.getProtocol() + "://" + this.url.getHost();
            if (this.url.getPort() != -1) {
                string2 = string2 + ":" + this.url.getPort();
            }
            string = string2 + string;
        }
        if (string.indexOf(10) == -1) {
            return string;
        }
        throw new MalformedURLException("Illegal character in URL");
    }

    public void writeRequests(MessageHeader messageHeader, PosterOutputStream posterOutputStream) throws IOException {
        this.requests = messageHeader;
        this.requests.print(this.serverOutput);
        this.poster = posterOutputStream;
        if (this.poster != null) {
            this.poster.writeTo(this.serverOutput);
        }
        this.serverOutput.flush();
    }

    public boolean parseHTTP(MessageHeader messageHeader, ProgressEntry progressEntry) throws IOException {
        try {
            this.serverInput = this.serverSocket.getInputStream();
            this.serverInput = new BufferedInputStream(this.serverInput);
            this.serverInput = new PushbackInputStream(this.serverInput, 8);
            return this.parseHTTPHeader(messageHeader, progressEntry);
        }
        catch (IOException iOException) {
            this.closeServer();
            if (!this.failedOnce && this.requests != null) {
                this.failedOnce = true;
                this.openServer();
                this.writeRequests(this.requests, this.poster);
                return this.parseHTTP(messageHeader, progressEntry);
            }
            throw iOException;
        }
    }

    private boolean parseHTTPHeader(MessageHeader messageHeader, ProgressEntry progressEntry) throws IOException {
        this.keepAliveConnections = -1;
        this.keepAliveTimeout = 0;
        boolean bl = false;
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            int n2 = this.serverInput.read(byArray, n, 8 - n);
            if (n2 < 0) break;
            n += n2;
        }
        String string = null;
        bl = byArray[0] == 72 && byArray[1] == 84 && byArray[2] == 84 && byArray[3] == 80 && byArray[4] == 47 && byArray[5] == 49 && byArray[6] == 46;
        ((PushbackInputStream)this.serverInput).unread(byArray);
        if (bl) {
            messageHeader.parseHeader(this.serverInput);
            if (this.usingProxy) {
                string = messageHeader.findValue("Proxy-Connection");
            }
            if (string == null) {
                string = messageHeader.findValue("Connection");
            }
            if (string != null && string.toLowerCase().equals("keep-alive")) {
                HeaderParser headerParser = new HeaderParser(messageHeader.findValue("Keep-Alive"));
                if (headerParser != null) {
                    this.keepAliveConnections = headerParser.findInt("max", 5);
                    this.keepAliveTimeout = headerParser.findInt("timeout", 5);
                }
            } else if (byArray[7] != 48) {
                this.keepAliveConnections = string != null ? 1 : 2;
            }
        } else {
            if (n != 8) {
                if (!this.failedOnce && this.requests != null) {
                    this.failedOnce = true;
                    this.closeServer();
                    this.openServer();
                    this.writeRequests(this.requests, this.poster);
                    return this.parseHTTP(messageHeader, progressEntry);
                }
                throw new SocketException("Unexpected end of file from server");
            }
            messageHeader.set("Content-type", "unknown/unknown");
        }
        n = -1;
        try {
            string = messageHeader.getValue(0);
            int n3 = string.indexOf(32);
            while (string.charAt(n3) == ' ') {
                ++n3;
            }
            n = Integer.parseInt(string.substring(n3, n3 + 3));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 100) {
            return this.parseHTTPHeader(messageHeader, progressEntry);
        }
        string = null;
        try {
            string = messageHeader.findValue("Transfer-Encoding");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null && string.equalsIgnoreCase("chunked")) {
            InputStream inputStream = this.serverInput;
            this.serverInput = new ChunkedInputStream(this.serverInput);
            messageHeader.set("content-length", Integer.toString(this.serverInput.available()));
            messageHeader.mergeHeader(inputStream);
        }
        int n4 = -1;
        try {
            n4 = Integer.parseInt(messageHeader.findValue("content-length"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.keepAliveConnections > 1 && n4 > 0) {
            this.keepingAlive = true;
        } else if (this.keepingAlive) {
            this.keepingAlive = false;
        }
        if (n4 > 0) {
            progressEntry.setType(this.url.getFile(), messageHeader.findValue("content-type"));
            progressEntry.update(0, n4);
            if (this.keepingAlive) {
                this.kas = new KeepAliveStream(this.serverInput, progressEntry, this);
                this.serverInput = this.kas;
                this.failedOnce = false;
            } else {
                this.serverInput = new MeteredStream(this.serverInput, progressEntry);
            }
        } else {
            ProgressData.pdata.unregister(progressEntry);
        }
        return bl;
    }

    public synchronized InputStream getInputStream() {
        return this.serverInput;
    }

    public OutputStream getOutputStream() {
        return this.serverOutput;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.url + ")";
    }

    public final boolean isKeepingAlive() {
        return this.getHttpKeepAliveSet() && this.keepingAlive;
    }

    protected void finalize() throws Throwable {
    }

    public void closeServer() {
        try {
            this.keepingAlive = false;
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getProxyHostUsed() {
        if (!this.usingProxy) {
            return null;
        }
        return this.instProxy;
    }

    public int getProxyPortUsed() {
        return this.instProxyPort;
    }
}

