/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.HashMap;
import java.util.jar.JarFile;
import sun.net.www.protocol.jar.URLJarFile;

class JarFileFactory {
    private static HashMap fileCache = new HashMap();
    private static HashMap urlCache = new HashMap();

    JarFileFactory() {
    }

    URLConnection getConnection(JarFile jarFile) throws IOException {
        URL uRL = (URL)urlCache.get(jarFile);
        if (uRL != null) {
            return uRL.openConnection();
        }
        return null;
    }

    public JarFile get(URL uRL) throws IOException {
        return this.get(uRL, true);
    }

    JarFile get(URL uRL, boolean bl) throws IOException {
        JarFile jarFile = null;
        JarFile jarFile2 = null;
        if (bl) {
            JarFileFactory jarFileFactory = this;
            synchronized (jarFileFactory) {
                jarFile = this.getCachedJarFile(uRL);
            }
            if (jarFile == null) {
                jarFile2 = URLJarFile.getJarFile(uRL);
                JarFileFactory jarFileFactory2 = this;
                synchronized (jarFileFactory2) {
                    jarFile = this.getCachedJarFile(uRL);
                    if (jarFile == null) {
                        fileCache.put(uRL, jarFile2);
                        urlCache.put(jarFile2, uRL);
                        jarFile = jarFile2;
                    } else if (jarFile2 != null) {
                        jarFile2.close();
                    }
                }
            }
        } else {
            jarFile = URLJarFile.getJarFile(uRL);
        }
        if (jarFile == null) {
            throw new FileNotFoundException(uRL.toString());
        }
        return jarFile;
    }

    private JarFile getCachedJarFile(URL uRL) {
        SecurityManager securityManager;
        Permission permission;
        JarFile jarFile = (JarFile)fileCache.get(uRL);
        if (jarFile != null && (permission = this.getPermission(jarFile)) != null && (securityManager = System.getSecurityManager()) != null) {
            try {
                securityManager.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securityManager.checkRead(permission.getName());
                }
                if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
                throw securityException;
            }
        }
        return jarFile;
    }

    private Permission getPermission(JarFile jarFile) {
        try {
            URLConnection uRLConnection = this.getConnection(jarFile);
            if (uRLConnection != null) {
                return uRLConnection.getPermission();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

